import Ember from 'ember';

export default Ember.Component.extend({

  classNameBindings: ['isPlaying:active'],

  hasPlayer: Ember.computed.bool('player'),

  begin: Ember.computed.readOnly('annotation.begin'),
  end: Ember.computed.readOnly('annotation.end'),
  title: Ember.computed.readOnly('annotation.title'),
  original: Ember.computed.readOnly('annotation.original'),
  speaker: Ember.computed.readOnly('annotation.speaker'),
  showSpeaker: Ember.computed.readOnly('annotation.showSpeaker'),
  literal: Ember.computed.readOnly('annotation.literal'),
  translation: Ember.computed.readOnly('annotation.translation'),

  isPlaying: Ember.computed("hasPlayer","player.progress", "begin", "end", function() {
    var progress = this.get('player.progress');
    return this.get('hasPlayer') && progress && (progress >= this.get('begin')) && (progress < this.get('end'));
  })

});
