import Ember from 'ember';

export default Ember.Component.extend({

    classNames: ['transcript-component'],

    player: Ember.inject.service(),

    autoscrollElement : '.corpus-app-container',
    previousElement: 0,
    autoscroll: true,
    timeout: null,

    hasSections: Ember.computed('player', 'player.transcript', function() {
      var sections = this.get('player.transcript.sections');
      return sections && sections.length > 0;
    }),

    itemObserver: Ember.observer('player.item', function () {
      if ( !(this.get('isDestroyed') || this.get('isDestroying')) ) {
          this.set('autoscroll', true);
      }
    }),

    didInsertElement: function() {
        Ember.$('#' + this.elementId).parent().on('scroll', Ember.run.bind(this, this.onScroll));
    },

    onScroll: function() {
        if ( !(this.get('isDestroyed') || this.get('isDestroying')) ) {
          this.set('autoscroll', false);
        }
        if(this.elementId) {
          Ember.$('#' + this.elementId).parent().off('scroll');
        }
    },

    scroll: Ember.observer('player.progress', function() {
      var self = this;
      var target = this.$('.sentence.active');
      if(this.get('autoscroll') && target.length && target.attr('id') !== this.get('previousElement')) {
          Ember.$('#' + self.elementId).parent().off('scroll');
          Ember.$(this.get('autoscrollElement')).animate({
              scrollTop: target.offset().top + Ember.$(this.get('autoscrollElement')).scrollTop() - Ember.$(this.get('autoscrollElement')).offset().top - 154
          }, 150, 'swing', function() {
              setTimeout(function() {
                  Ember.$('#' + self.elementId).parent().on('scroll', Ember.run.bind(self, self.onScroll));
              }, 100);
          });
          this.set('previousElement', target.attr('id'));
      }
    }),


    actions: {

        play: function(progress) {
            this.get('player').trigger('progressupdate', progress);
            this.get('player').set('playing', true);
        }
    }

});
