var gulp = require('gulp'),
    elixir = require('laravel-elixir');


var exec = require('child_process').execSync;
/*
 |--------------------------------------------------------------------------
 | Elixir Asset Management
 |--------------------------------------------------------------------------
 |
 | Elixir provides a clean, fluent API for defining some basic Gulp tasks
 | for your Laravel application. By default, we are compiling the Less
 | file for our application, as well as publishing vendor resources.
 |
 */

 var paths = {
 'bower_base_path': './vendor/bower_components/',
 'bootstrap': './vendor/bower_components/bootstrap-sass/assets/'
 };

gulp.task('build-ember', function(cb) {
    exec('node_modules/.bin/ember build -prod', {
        cwd: '../bo_client',
        stdio:[0,1,2]
    });
});


gulp.task('copy-bo-ember', function() {
    gulp.src('../bo_client/dist/assets/*.js')
        .pipe(gulp.dest('public/js/vendor/'));
    gulp.src('../bo_client/dist/assets/*.css')
        .pipe(gulp.dest('public/css/vendor/'));
});

elixir(function(mix) {
    mix.sass('app.scss', 'public/css/app.css', {includePaths: [paths['bootstrap']+'stylesheets/']})
        .copy(paths.bootstrap + 'fonts/bootstrap', 'public/fonts')
        .copy(paths.bootstrap + 'javascripts/bootstrap.js', 'public/js/vendor/bootstrap.js')
        .copy(paths.bower_base_path + 'jquery/dist/jquery.min.js', 'public/js/vendor/jquery.js')
        .copy(paths.bower_base_path + 'font-awesome/css/font-awesome.min.css', 'public/css/vendor/font-awesome.css')
        .task('build-ember')
        .task('copy-bo-ember');
});
