import Ember from 'ember';

export default Ember.Route.extend({

    index: 0,
    limit: 40,
    sort: 'alphabetical',

    themes: [],

    model: Ember.observer('index', function() {
        var self = this;
        var promise = this.store.query('theme', {
            'limit': this.get('limit'),
            'index': this.get('index'),
            'sort': this.get('sort')
        });
        promise.then(function(value) {
            if (self.get('themes').length) {
                value = self.get('themes').pushObjects(value.get('content'));
            }
            self.set('themes', value);
        });
        return promise;
    }),

    setupController: function(controller) {
        this._super(...arguments);
        controller.set('themes', this.get('themes'));
    },

    actions: {

        setIndexQueryparams: function() {
            this.set('index', this.get('index') + 1);
        },

        setSortQueryparams: function(sort) {
            this.set('sort', sort);
            this.get('themes').replaceContent(0, this.get('themes').get('content').length, null);
            // Force property reset to trigger request.
            this.propertyWillChange('index');
            this.set('index', 0);
            this.propertyDidChange('index');            
        }
        
    }

});
