import DS from 'ember-data';
import Ember from 'ember';
import _ from 'lodash/lodash';
import * as utils from 'corpus-common-addon/utils/utils';

export default DS.Model.extend({
    //id: attr('string'),
    uri: DS.attr('string'),

    title: DS.attr('string'),

    languages: DS.attr({defaultValue: function() { return []; }}),

    publishers: DS.attr({defaultValue: function() { return []; }}),

    contributors: DS.attr({defaultValue: function() { return []; }}),

    subjects: DS.attr({defaultValue: function() { return []; }}),

    geoInfo: DS.attr({defaultValue: function() { return []; }}),

    mediaArray: DS.attr({defaultValue: function() { return []; }}),

    encodedId: Ember.computed('id', function() {
        return encodeURIComponent(this.get('id'));
    }),

    mediaList: Ember.computed('mediaArray', function() {
        var res = [];
        var mp3 = null;
        _.forEach(this.get('mediaArray'), function(m) {
            if(m.format === 'audio/mpeg') {
                mp3 = m;
            } else if (m.format.startsWith('audio/')) {
                res.push(m);
            }
        });
        if(mp3) {
            res.unshift(mp3);
        }
        return res;
    }),

    reflocs: Ember.computed('geoInfo', function() {
        return this.get('geoInfo')['ref-locs'];
    }),

    addContributor: function(contrib_def) {
        var contributors = this.get('contributors');
        if(_.findIndex(contributors, function(c) { return _.isEqual(c, contrib_def);}) < 0) {
            contributors.pushObject(contrib_def);
        }
        // must set dirty
        this.set('contributors', _.clone(this.get('contributors')));
    },
    removeContributor: function(contrib_def) {
        var contributors = this.get('contributors');
        var index = _.findIndex(contributors, function(c) { return _.isEqual(c, contrib_def);});
        if(index >= 0) {
            contributors.removeAt(index);
        }
        //must set dirty
        this.set('contributors', _.clone(this.get('contributors')));
    },
    saveContributor: function(contrib_def, index) {
        var contributors = this.get('contributors');
        if(index < 0 || index >= contributors.length) {
            return;
        }

        var contrib_def_map = {name: contrib_def.name||'', url: contrib_def.url||'', role: contrib_def.role||''};
        var existingContribs = _.filter(contributors, function(c, i) {
            return (i!==index && _.isEqual({name: c.name||'', url: c.url||'', role: c.role||''}, contrib_def_map));
        });
        if(existingContribs.length > 0) {
            // contributor exists, remove contributor @ index
            contributors.removeAt(index);
        }
        else {
            contributors[index] = contrib_def;
        }
        //must set dirty only if needed
        this.set('contributors', _.clone(this.get('contributors')));
    },
    removeSubject: function(subject_def) {
        var subjects = this.get('subjects');
        var index = _.findIndex(subjects, function(s) { return _.isEqual(s, subject_def);});
        if(index >= 0) {
            subjects.removeAt(index);
        }
        //must set dirty
        this.set('subjects', _.clone(subjects));
    },
    addSubject: function(subject_def) {
        var subjects = this.get('subjects');
        if(_.findIndex(subjects, function(s) { return _.isEqual(s, subject_def) || _.isEqual(s, utils.switchArkBnfLink(subject_def));}) < 0) {
            subjects.pushObject(subject_def);
        }
        // must set dirty
        this.set('subjects', _.clone(subjects));
    }

});
