class sysconfig::php (
) inherits sysconfig::params {

    $php_packages = [
        'php56',
        'php56-php',
        'php56-php-common',
        'php56-php-mbstring',
        'php56-php-mcrypt',
        'php56-php-pdo',
        'php56-php-pecl-memcache',
        'php56-php-gd',
        'php56-php-mysqlnd',
        'php56-php-pecl-imagick'
    ]

    package { $php_packages:
        ensure => present,
        require => Package["httpd"]
    }

    file { '/var/log/php':
        ensure => directory,
        owner => 'apache',
        group => 'apache',
        require => Package["httpd"]
    }

    augeas { "php_ini/memory_limit":
        lens    => "PHP.lns",
        incl    => "/opt/remi/php56/root/etc/php.ini",
        changes => "set PHP/memory_limit 128M",
        notify => Service['httpd'],
        require => Package["php56"]
    }->
    augeas { "php_ini/max_execution_time":
        lens    => "PHP.lns",
        incl    => "/opt/remi/php56/root/etc/php.ini",
        changes => "set PHP/max_execution_time 50",
        notify => Service['httpd'],
        require => Package["php56"]
    }->
    augeas { "php_ini/upload_max_filesize":
        lens    => "PHP.lns",
        incl    => "/opt/remi/php56/root/etc/php.ini",
        changes => "set PHP/upload_max_filesize 50M",
        notify => Service['httpd'],
        require => Package["php56"]
    }->
    augeas { "php_ini/error_log":
        lens    => "PHP.lns",
        incl    => "/opt/remi/php56/root/etc/php.ini",
        changes => "set PHP/error_log /var/log/php/php_errors.log",
        notify => Service['httpd'],
        require => [Package["php56"], File['/var/log/php']]
    }
#TODO : set php log
    file { "/var/www/html/phpinfo.php":
        mode   => 440,
        owner  => 'apache',
        group  => 'apache',
        source => "puppet:///modules/sysconfig/phpinfo.php",
        require => Package["httpd"]
    }

}
