import Ember from 'ember';

export default Ember.Controller.extend({
  queryParams: ['location', 'langue', 'discours', 'date', 'thematique'],
  location: null,
  langue: null,
  discours: null,
  date: null,
  thematique: null,
  filteredSounds: Ember.computed('location', 'langue', 'discours', 'date', 'thematique', 'model', function() {
    var location = this.get('location');
    var langue = this.get('langue');
    var discours = this.get('discours');
    var date = this.get('date');
    // var thematique = this.get('thematique');

    var sounds = this.get('model');

    if (location) {
      sounds = sounds.filterBy('spatial', location);
    }
    if (langue) {
      sounds = sounds.filterBy('language', langue);
    }
    if (discours) {
      sounds = sounds.filterBy('type', discours);
    }
    if (date) {
      sounds = sounds.filterBy('created', parseInt(date));
    }
    // if (thematique) {
    //   sounds = sounds.filterBy('thematique', thematique);
    // }

    return sounds;
  }),
  model(params){
    return this.store.query('sound', params);
  },
  actions: {
    deleteTag: function(query){
      var queryParams = {};
      queryParams[query]  = null;
      this.transitionToRoute({queryParams: queryParams});
    }
  }
});
