import DS from 'ember-data';
import Ember from 'ember';
import _ from 'lodash/lodash';

export default DS.Model.extend({
  //id: attr('string'),
  uri: DS.attr('string'),

  title: DS.attr('string'),

  language: DS.attr('string'),

  publishers: DS.attr({defaultValue: function() { return []; }}),

  contributors: DS.attr({defaultValue: function() { return []; }}),

  subjects: DS.attr({defaultValue: function() { return []; }}),

  mediaArray: DS.attr({defaultValue: function() { return []; }}),

  mediaList: Ember.computed('mediaArray', function() {
    var res = [];
    var mp3 = null;
    _.forEach(this.get('mediaArray'), function(m) {
      if(m.format === 'audio/mpeg') {
        mp3 = m;
      } else if (m.format.startsWith('audio/')) {
        res.push(m);
      }
    });
    if(mp3) {
      res.unshift(mp3);
    }
    return res;
  }),

  addContributor: function(contrib_def) {
    var contributors = this.get('contributors');
    if(_.findIndex(contributors, function(c) { return _.isEqual(c, contrib_def);}) < 0) {
      contributors.pushObject(contrib_def);
    }
    // must set dirty
    this.set('contributors', _.clone(this.get('contributors')));
  },
  removeContributor: function(contrib_def) {
    var contributors = this.get('contributors');
    var index = _.findIndex(contributors, function(c) { return _.isEqual(c, contrib_def);});
    if(index >= 0) {
      contributors.removeAt(index);
    }
    //must set dirty
    this.set('contributors', _.clone(this.get('contributors')));
  },
  saveContributor: function(contrib_def, index) {
    var contributors = this.get('contributors');
    if(index < 0 || index >= contributors.length) {
      return;
    }

    var contrib_def_map = {name: contrib_def.name||"", url: contrib_def.url||"", role: contrib_def.role||""};
    var existingContribs = _.filter(contributors, function(c, i) {
      return (i!==index && _.isEqual({name: c.name||"", url: c.url||"", role: c.role||""}, contrib_def_map));
    });
    if(existingContribs.length > 0) {
      // contributor exists, remove contributor @ index
      contributors.removeAt(index);
    }
    else {
      contributors[index] = contrib_def;
    }
    //must set dirty only if needed
    this.set('contributors', _.clone(this.get('contributors')));
  }

});
