<?php
namespace CorpusParole\Libraries\Mappers;

use EasyRdf\Graph;

use CorpusParole\Libraries\CocoonUtils;

//<http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-COLLECTION_ALA_CL> a <http://crdo.risc.cnrs.fr/schemas/Resource> ;
//	<http://purl.org/dc/elements/1.1/description> """Cette sÃ©rie d'entretiens semi-dirigÃ©s avait comme objectif de susciter un discours
//            sur les pratiques linguistiques des locuteurs. Les locuteurs se sont exprimÃ©s dans la langue de leur choix.
//            Le questionnaire servant de trame Ã  l'entretien comportait les volets suivants :
//            # la biographie sociolinguistique
//            # la dÃ©limitation de l'espace de vie et de l'espace linguistique d'appartenance
//            # l'auto-Ã©valuation des compÃ©tences linguistiques en alsacien, en franÃ§ais et en allemand
//            # les normes linguistiques des trois variÃ©tÃ©s
//            # les variations (alsacien, franÃ§ais, allemand)
//            # les pratiques linguistiques et langagiÃ¨res
//            # l'idÃ©ologie linguistique (rapport langue / identitÃ©, dialecte / Ã©cole â¦)."""@fr ;
//    <http://purl.org/dc/elements/1.1/type> "primary_text"^^<http://www.language-archives.org/OLAC/1.1/linguistic-type> , "dialogue"^^<http://www.language-archives.org/OLAC/1.1/discourse-type> , <http://purl.org/dc/dcmitype/Collection> , "lexicon"^^<http://www.language-archives.org/OLAC/1.1/linguistic-type> ;
//    <http://purl.org/dc/elements/1.1/subject> <http://lexvo.org/id/iso639-3/gsw> ;
//    <http://purl.org/dc/elements/1.1/language> <http://lexvo.org/id/iso639-3/gsw> ;
//    <http://www.language-archives.org/OLAC/1.1/depositor> <http://viaf.org/viaf/9122216> ;
//    <http://purl.org/dc/elements/1.1/publisher> "Atlas linguistiques, cultures et parlers régionaux de France" ;
//    <http://purl.org/dc/elements/1.1/rights> "Copyright (c) Département de dialectologie alsacienne et mosellane de l'Université de Strasbourg" ;
//    <http://purl.org/dc/elements/1.1/title> "Atlas Linguistique et ethnographique de l'Alsace: Enquêtes sur la conscience linguistique"@fr ;
//    <http://purl.org/dc/terms/accessRights> "Freely available for non-commercial use" ;
//    <http://purl.org/dc/terms/license> <http://creativecommons.org/licenses/by-nc-nd/2.5/> ;
//    <http://purl.org/dc/terms/isPartOf> <http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-COLLECTION_ALA> ;
//    <http://purl.org/dc/terms/created> "start=1988; end=1989"^^<http://purl.org/dc/terms/Period> ;
//    <http://purl.org/dc/terms/spatial> "France, Alsace"@fr , "FR"^^<http://purl.org/dc/terms/ISO3166> ;
//    <http://purl.org/dc/terms/available> "2014-04-18"^^<http://purl.org/dc/terms/W3CDTF> ;
//    <http://purl.org/dc/terms/issued> "2015-07-09T09:40:21 02:00"^^<http://purl.org/dc/terms/W3CDTF> ;
//    <http://www.language-archives.org/OLAC/1.1/transcriber> "Huck, Dominique" ;
//    <http://www.language-archives.org/OLAC/1.1/researcher> "Bothorel-Witz, Arlette" .

// http://purl.org/dc/elements/1.1/description
// http://purl.org/dc/elements/1.1/language
// http://purl.org/dc/elements/1.1/publisher
// http://purl.org/dc/elements/1.1/rights
// http://purl.org/dc/elements/1.1/subject
// http://purl.org/dc/elements/1.1/title
// http://purl.org/dc/elements/1.1/type
// http://purl.org/dc/terms/accessRights
// http://purl.org/dc/terms/available
// http://purl.org/dc/terms/created
// http://purl.org/dc/terms/issued
// http://purl.org/dc/terms/license
// http://purl.org/dc/terms/spatial
// http://www.language-archives.org/OLAC/1.1/depositor
// http://www.language-archives.org/OLAC/1.1/researcher
// http://www.language-archives.org/OLAC/1.1/transcriber
// http://purl.org/dc/terms/isPartOf
// http://www.language-archives.org/OLAC/1.1/compiler
// http://www.language-archives.org/OLAC/1.1/data_inputter
// http://www.language-archives.org/OLAC/1.1/developer
// http://www.language-archives.org/OLAC/1.1/interviewer
// http://www.language-archives.org/OLAC/1.1/sponsor
// http://www.w3.org/2003/01/geo/wgs84_pos#lat
// http://www.w3.org/2003/01/geo/wgs84_pos#long

class CocoonCollectionRdfMapper extends CocoonAbstractRdfMapper {

    protected function getResourceBaseId($res=null) {

        if(is_null($res)) {
            $res = $this->inputGraph->resource($this->uri);
        }
        return $res->getUri();
    }

    protected function mapResource($res, $outputGraph) {
        $resId = CocoonUtils::getIdFromUri($this->getResourceBaseId($res));
        $resUri = CocoonUtils::getCorpusUriFromId($resId);

        $collNode = $outputGraph->resource($resUri, 'edm:Collection');

        $collNode->addResource('http://purl.org/dc/terms/isVersionOf', $this->getResourceBaseId());

        $this->addSimpleProperties($collNode, $res);
        $this->addDateProperties($collNode, $res, $outputGraph);
        $this->addSpatialProperties($collNode, $res, $outputGraph);

        $this->mapCollections($res);
    }


    protected function addSimpleProperties($targetRes, $sourceRes) {
        $this->applyPropertiesToRes($sourceRes, $targetRes, [
            ['http://purl.org/dc/elements/1.1/description', null],
            ['http://purl.org/dc/elements/1.1/language', null],
            ['http://purl.org/dc/elements/1.1/publisher', null],
            ['http://purl.org/dc/elements/1.1/rights', null],
            ['http://purl.org/dc/elements/1.1/type', null],
            ['http://purl.org/dc/terms/license', null],
            ['http://purl.org/dc/elements/1.1/subject', null],
            ['http://purl.org/dc/elements/1.1/title', null],
            ['http://purl.org/dc/elements/1.1/language', null],
            ['http://purl.org/dc/terms/accessRights', 'propertyTrimMap'],
            ['http://purl.org/dc/terms/extent', null],
            ['http://purl.org/dc/terms/isPartOf', 'propertyCollectionMap'],
            ['http://www.language-archives.org/OLAC/1.1/annotator', 'propertyOlacRoleMap'],
            ['http://www.language-archives.org/OLAC/1.1/author', 'propertyOlacRoleMap'],
            ['http://www.language-archives.org/OLAC/1.1/compiler', 'propertyOlacRoleMap'],
            ['http://www.language-archives.org/OLAC/1.1/consultant', 'propertyOlacRoleMap'],
            ['http://www.language-archives.org/OLAC/1.1/data_inputter', 'propertyOlacRoleMap'],
            ['http://www.language-archives.org/OLAC/1.1/depositor', 'propertyOlacRoleMap'],
            ['http://www.language-archives.org/OLAC/1.1/developer', 'propertyOlacRoleMap'],
            ['http://www.language-archives.org/OLAC/1.1/editor', 'propertyOlacRoleMap'],
            ['http://www.language-archives.org/OLAC/1.1/illustrator', 'propertyOlacRoleMap'],
            ['http://www.language-archives.org/OLAC/1.1/interpreter', 'propertyOlacRoleMap'],
            ['http://www.language-archives.org/OLAC/1.1/interviewer', 'propertyOlacRoleMap'],
            ['http://www.language-archives.org/OLAC/1.1/participant', 'propertyOlacRoleMap'],
            ['http://www.language-archives.org/OLAC/1.1/performer', 'propertyOlacRoleMap'],
            ['http://www.language-archives.org/OLAC/1.1/photographer', 'propertyOlacRoleMap'],
            ['http://www.language-archives.org/OLAC/1.1/recorder', 'propertyOlacRoleMap'],
            ['http://www.language-archives.org/OLAC/1.1/researcher', 'propertyOlacRoleMap'],
            ['http://www.language-archives.org/OLAC/1.1/research_participant', 'propertyOlacRoleMap'],
            ['http://www.language-archives.org/OLAC/1.1/responder', 'propertyOlacRoleMap'],
            ['http://www.language-archives.org/OLAC/1.1/signer', 'propertyOlacRoleMap'],
            ['http://www.language-archives.org/OLAC/1.1/singer', 'propertyOlacRoleMap'],
            ['http://www.language-archives.org/OLAC/1.1/speaker', 'propertyOlacRoleMap'],
            ['http://www.language-archives.org/OLAC/1.1/sponsor', 'propertyOlacRoleMap'],
            ['http://www.language-archives.org/OLAC/1.1/transcriber', 'propertyOlacRoleMap'],
            ['http://www.language-archives.org/OLAC/1.1/translator', 'propertyOlacRoleMap'],
        ]);
    }



}
