import Ember from 'ember';

export default Ember.Component.extend({
  tagName: "tr",
  bnfId: null,
  initialBnfId: null,
  actions: {
    addNewContributor: function() {
      if(!this.get('valuesNotSet')) {
        this.get('onAdd')(this.getProperties('label','url'));
        this.clearProperties();
      }
    }
  },
  clearProperties: function() {
    var subjectDef = {
      bnfId: null,
    };
    this.setProperties(subjectDef);
    //clear typeahead
    this.$('.aupac-typeahead').typeahead('val','');
  },

  _clearAfterRender: function() {
    Ember.run.schedule('afterRender', this, function () {
      this.clearProperties();
    });
  }.on('init'),

  valuesNotSet: Ember.computed('url', function() {
    return !( this.get('url') );
  }),

  label: Ember.computed('bnfId', function() {
    var bnfId = this.get('bnfId');
    return (bnfId == null)?"":bnfId.value;
  }),

  url: Ember.computed('bnfId', function() {
    var bnfId = this.get('bnfId');
    return (bnfId == null)?"":bnfId.url;
  }),

  urlPresent: Ember.computed.bool('url'),

});
