import Ember from 'ember';
import URI from 'urijs';
import suggestionTemplate from 'bo-client/templates/components/bo-doc-bnf-autocomplete/suggestion';
import _ from 'lodash/lodash';

export default Ember.Component.extend({
  env: function() {
    return Ember.getOwner(this).resolveRegistration('config:environment');
  },
  actions: {
    setBnfId: function(value) {
      if(_.isString(value)) {
        this.set('bnfId', {
          label: value,
          value: value,
          id: "",
          url: "",
          nametype: "" }
        );
      }
      else {
        this.set('bnfId', value);
      }
    },
  },

  limit: 15,

  display(selection) {
    return selection.value;
  },

  setValue(selection) {
    let typeahead = Ember.$(this.$(), ".aupac-typeahead");
    if(selection) {
      if(_.isString(selection)) {
        typeahead.typeahead('val', selection);
      } else {
        typeahead.typeahead('val', selection.value);
      }

    } else {
      typeahead.typeahead('val', '');
    }
  },

  keyDown(event) {
    if(event.which === this.get('constants').KEY_CODES.RETURN) {
      Ember.$(this.$(), ".aupac-typeahead").typeahead('close');
    }
  },

  suggestionTemplate: suggestionTemplate,

  _registerAfterRender: function() {
    Ember.run.schedule('afterRender', this, function () {
      this.set('registerAs', this);
    });
  }.on('init'),


  bnfSource : function(query, syncResults, asyncResults) {
    var url = URI(this.env().APP['bo-doc-bnf-autocomplete'].bnfQueryUrl).query({term: query}).toString();
    Ember.$.ajax({
      url: url,
      dataType: "jsonp",
      success: function(data) {
        var queryTextRes = {
          label: query,
          value: query,
          id: "",
          url: "",
          nametype: ""
        };
        if (data.result) {
          var results = Ember.$.map( data.result, function(item) {
            var retLbl = item.term + " [" + item.nametype + "]",
                bnfurl = this.env().APP['bo-doc-viaf-autocomplete'].viafBaseUrl + item.bnfid;
            return {
              label: retLbl,
              value: item.term,
              id: item.bnfid,
              url: bnfurl,
              nametype: item.nametype
            };
          });
          results.unshift(queryTextRes);
          asyncResults( results );
        } else {
          asyncResults([queryTextRes]);
        }
      },
    });
  }

});
