import Ember from 'ember';
import _ from 'lodash/lodash';
import * as utils from 'corpus-common-addon/utils/utils';

export default Ember.Component.extend({
  isEditing: false,
  subjectsList: Ember.computed("document.subjects[]", function() {
    return _.union(
      _.filter(this.get("document").get("subjects"), utils.isBnfLink),
      _.filter(this.get("document").get("subjects"), function(s) { return !utils.isBnfLink(s); })
    );
  }),
  actions: {
    toggleEditSubjects: function() {
      this.set('isEditing', !this.get('isEditing'));
      this.$('#doc-subjects-table-pane').slideToggle();
      this.$('#doc-subjects-list-pane').slideToggle();
    },
  }

});
