import Ember from 'ember';
import AmCharts from 'ammaps';
import ENV from 'app-client/config/environment';

export default Ember.Component.extend({

    constants: Ember.inject.service(),

    map: null,

    continentsMapVar: AmCharts.maps.continentsLow,
    continentsAreas: [],
    countriesMapVar: AmCharts.maps.worldLow,
    countriesAreas: [],
    franceMapVar: AmCharts.maps.france2016Low,
    franceAreas: [],

    locationQueryParam: '',
    dataProvider: {},

    color: 'rgba(113,132,141,.2)',

    filter: Ember.inject.service(),
    locationObserver: Ember.observer('filter.location', function() {
        if(!this.get('filter').get('location')) {
            this.sendAction('setLocation', this.get('constants').GEONAMES['world']);
        }
    }),

    geostats: [],
    observerGeostats: Ember.observer('geostats', function() {
        if(this.get('map')) {
            if(this.get('map').selectedObject.id) {
                if(this.get('map').selectedObject.parentObject.mapVar === this.get('countriesMapVar')) {
                    if(this.get('map').selectedObject.id === this.get('constants').GEONAMES['france']) {
                        this.setFranceAreas();
                        this.set('dataProvider', {
                            'mapVar': this.get('franceMapVar'),
                            'getAreasFromMap': true,
                            'areas': this.get('franceAreas')
                        });
                        this.get('map')['dataProvider'] = this.get('dataProvider');
                        this.get('map').validateData();
                    }
                } else if(this.get('map').selectedObject.parentObject.mapVar === this.get('continentsMapVar')) {
                    this.setCountriesAreas();
                    this.set('dataProvider', {
                        'mapVar': this.get('countriesMapVar'),
                        'getAreasFromMap': true,
                        'areas': this.get('countriesAreas'),
                        'zoomLevel': this.get('map').zoomLevel(),
                        'zoomLatitude': this.get('map').zoomLatitude(),
                        'zoomLongitude': this.get('map').zoomLongitude()
                    });
                    this.get('map')['dataProvider'] = this.get('dataProvider');
                    this.get('map').validateData();
                }
            } else {
                this.setContinentsAreas();
                this.set('dataProvider', {
                    'mapVar': this.get('continentsMapVar'),
                    'areas': this.get('continentsAreas')
                });
                this.createAmMap();
            }
        }
    }),

    init: function() {
        this._super(...arguments);
        if (ENV.environment === 'development') {
            this.set('color', '#f3f3f3');
        }
    },

    setFranceAreas: function() {
        var self = this;
        var france2016LowAreas = [];
        this.get('franceMapVar')['svg']['g']['path'].forEach(function(area) {
            var object = {
                'id': area.id,
                'passZoomValuesToTarget': false,
                'autoZoom': false
            };
            var departments = self.get('geostats').find(geostat => geostat.id === area.id);
            if(typeof departments === 'undefined') {
                object['mouseEnabled'] = false;
                object['color'] = self.get('color');
            } else {
                object['value'] = departments.get('count');
            }
            france2016LowAreas.push(object);
        });
        this.set('franceAreas', france2016LowAreas);
    },

    setCountriesAreas: function() {
        var self = this;
        var worldLowAreas = [];
        this.get('countriesMapVar')['svg']['g']['path'].forEach(function(area) {
            var countries = self.get('geostats').find(geostat => geostat.id === area.id);
            if(typeof countries === 'undefined') {
                worldLowAreas.push({
                    'id': area.id,
                    'mouseEnabled': false,
                    'color': self.get('color')
                });
            } else {
                if(typeof worldLowAreas.find(country => country.id === area.id) === 'undefined') {
                    var object = {
                        'id': area.id,
                        'selectable': true,
                        'value': countries.get('count')
                    };
                    if(area.id === 'FR') {
                        object['autoZoom'] = true;
                    }
                    worldLowAreas.push(object);
                }
            }
        });
        this.set('countriesAreas', worldLowAreas);
    },

    setContinentsAreas: function() {
        var self = this;
        var continentsLowAreas = [];
        this.get('continentsMapVar')['svg']['g']['path'].forEach(function(area) {
            var object = {
                'id': area.id,
                'passZoomValuesToTarget': true,
                'selectable': true,
                'mouseEnabled': true,
                'autoZoom': true
            };
            var continent = self.get('geostats').find(geostat => geostat.id === area.id);
            if(typeof continent === 'undefined') {
                object['mouseEnabled'] = false;
                object['color'] = self.get('color');
            } else {
                object['value'] = continent.get('count');
            }
            continentsLowAreas.push(object);
        });
        this.set('continentsAreas', continentsLowAreas);
    },

    didInsertElement: function(){
        this.$('#mapdiv').height(Ember.$('.corpus-app-container').height());
        this.createAmMap();
    },

    createAmMap: function() {

        this.setContinentsAreas();
        this.set('dataProvider', {
            'mapVar': this.get('continentsMapVar'),
            'areas': this.get('continentsAreas')
        });
        this.set('map', AmCharts.makeChart('mapdiv', {
            'type': 'map',
            'fontFamily': 'sans-serif',
            'fontSize': '12px',
            'dragMap': false,
            'zoomOnDoubleClick': false,
            'language': 'fr',
            'areasSettings': {
                'autoZoom': false,
                'selectable': true,
                'color': '#777777',
                'colorSolid': '#333333',
                'colorOutline': '#253946',
                'selectedColor': '#0085cb',
                'rollOverColor': '#0085cb',
                'rollOverOutlineColor': '#ffffff'
            },
            'zoomControl': {
                'zoomControlEnabled': false,
            },
            'dataProvider': this.get('dataProvider'),
            listeners: [{
                'event':'clickMapObject',
                'method': Ember.run.bind(this, 'clickMapObject')
            }, {
                'event':'homeButtonClicked',
                'method': Ember.run.bind(this, 'homeButtonClicked')
            }]
        }));
    },

    clickMapObject: function(event) {
        this.set('locationQueryParam', event.mapObject.id);
        this.sendAction('setLocation', event.mapObject.id);
        this.get('filter').set('location', event.mapObject.title);
    },

    homeButtonClicked: function(event) {
        if(event.chart.dataProvider.map !== 'continentsLow') {
            this.get('filter').set('location', null);
        }
    }

});
