<?php

use Mockery as m;

use EasyRdf\Resource;
use EasyRdf\Literal;
use CorpusParole\Services\ViafResolverException;

/**
 *
 */
class LanguageControllerTest extends TestCase {

    private $sparqlClient;

    public function setUp() {

        parent::setup();

        // create a mock of the post repository interface and inject it into the
        // IoC container
        $this->sparqlClient = m::mock('CorpusParole\Libraries\Sparql\SparqlClient');
        $this->app->instance('CorpusParole\Libraries\Sparql\SparqlClient', $this->sparqlClient);
    }

    public function tearDown() {
        m::close();
        parent::tearDown();
    }

    public function testIndex() {
        $query = "select ?lang (count(?lang) as ?count) where {
            ?s a <http://www.europeana.eu/schemas/edm/ProvidedCHO>.
            ?s <http://purl.org/dc/elements/1.1/language> ?lang
        }
        GROUP BY ?lang
        ORDER BY DESC(?count)";

        $this->sparqlClient
            ->shouldReceive('query')
            ->with($query)
            ->once()
            ->andReturn(new \ArrayIterator([
                (object)['lang'=>new Resource('http://lexvo.org/id/iso639-3/gsw'), 'count' => Literal::create(44)],
                (object)['lang'=>new Resource('http://lexvo.org/id/iso639-3/fra'), 'count' => Literal::create(33)],
                (object)['lang'=>new Resource('http://lexvo.org/id/iso639-3/bre'), 'count' => Literal::create(22)],
            ]));
        $response = $this->get('/api/v1/stats/languages/')->
            seeJsonEquals(['languages' => [
                'http://lexvo.org/id/iso639-3/gsw' => 44,
                'http://lexvo.org/id/iso639-3/fra' => 33,
                'http://lexvo.org/id/iso639-3/bre' => 22,
            ]]);
    }
}
