import Ember from 'ember';
import _ from 'lodash/lodash';

export default Ember.Controller.extend({

    player: Ember.inject.service(),
    filter: Ember.inject.service(),


    playerVideoscreenObserver: Ember.observer('player.videoscreen', function() {
        Ember.$('body').toggleClass('videoscreen', this.get('player').get('videoscreen'));
    }),

    // queryParams: ['location', 'date', 'notice', 'language', 'discourse', 'theme'],
    // queryParams: Ember.computed('filter.queryParams', 'notice', function() {
    //     const queryParamsList = this.get('filter').get('queryParams');
    //     return _.merge(queryParamsList, {'notice' : this.get('notice')});
    // }),
    queryParams : Ember.computed('filter.queryParams', function() {
        var res = _.clone(this.get('filter').get('queryParams'));
        res.push('notice');
        return res;
    }),

    location: Ember.computed.alias('filter.location'),
    date: Ember.computed.alias('filter.date'),
    language: Ember.computed.alias('filter.language'),
    discourse: Ember.computed.alias('filter.discourse'),
    theme: Ember.computed.alias('filter.theme'),

    itemObserver: Ember.observer('player.item', function() {
        var self = this;
        this.store.findRecord('document', this.get('player').get('item'), { reload: true }).then(function(model){
            self.get('player').set('model', model);
            if (self.get('player').get('model').get('transcript')) {
                self.store.findRecord('transcript', self.get('player').get('item')).then(function(model) {
                    self.get('player').set('transcript', model);
                });
            } else {
                self.get('player').set('transcript', null);
            }
        });
    }),

    notice: null,
    noticeModel: null,

    noticeObserver: Ember.observer('notice', function() {
        var self = this;
        if (this.get('notice')) {
            this.store.findRecord('document', this.get('notice'), { reload: true }).then(function(model){
                self.set('noticeModel', model);
            });
        }
    }),
    noticeModelObserver: Ember.observer('noticeModel', function() {
        if (!this.get('noticeModel')) {
            this.set('notice', null);
        }
    }),

    init: function() {
        this._super(...arguments);
        this.get('player');
    },

    actions: {

        changeDocument: function(docDirection){
            var direction = (docDirection === "next") ? 1 : -1;
            var currentObject = this.get("filteredDocuments").findBy('id', this.get("currentItem").get('id'));
            if ( currentObject !== 'undefined'){
                var index = this.get("filteredDocuments").indexOf(currentObject);
                if ( typeof(this.get("filteredDocuments").objectAt(index+direction)) !== 'undefined'){
                    return this.set('currentId', this.get("filteredDocuments").objectAt(index+direction).id);
                }
            }
            return this.set('currentId', this.get('filteredDocuments').get('firstObject').id);
        },
        play: function(item){
            this.set("currentId", item.id);
        }

    }
});
