import Ember from 'ember';

export default Ember.Component.extend({

  isEditing: false,
  viafResolver: Ember.inject.service(),
  document: null,
  i18n: Ember.inject.service(),

  _resolveViafIds: Ember.on('init', Ember.observer('document.contributors.[]', function() {
    this.get('document.contributors').forEach(function(contrib/*, index, coll*/) {
      if(contrib.url &&  !contrib.name) {
        this.get('viafResolver').getName(contrib.url).then( function(str) {
          Ember.set(contrib, 'name', str);
        }.bind(this), function(message) {
          console.error("viaf resolver error : ", message);
        });
      }
    }, this);
  })),

  actions: {
    toggleEditContributors: function() {
      // var contributors = _.clone(this.get('document').get('contributors'));
      // console.log("EDIT CONTRIBUTPRS", contributors);
      // contributors.push({
      //   name: "Hello world",
      //   url: null,
      //   role: 'http://www.language-archives.org/OLAC/1.1/annotator'
      // });
      // this.get('document').set('contributors', contributors);
      this.set('isEditing', !this.get('isEditing'));
      this.$('#doc-contributors-table-pane').slideToggle();
      this.$('#doc-contributors-list-pane').slideToggle();
    },
    addNewContributor: function(contrib_def) {
      if(contrib_def.name || contrib_def.url || contrib_def.role) {
        this.get('document').addContributor(contrib_def);
      }
    },
    removeContributor: function(contrib_def) {
      this.get("document").removeContributor(contrib_def);
    },
    saveContributor: function(contrib_def, index) {
      if(contrib_def.name || contrib_def.url || contrib_def.role) {
        this.get('document').saveContributor(contrib_def, index);
      }
    }
  },

});
