const gulp = require('gulp');
const del = require('del');
const zip = require('gulp-zip');
const merge = require('merge-stream');
const seq = require('run-sequence');
const exec = require('child_process').execSync;
const minimist = require('minimist');
const template = require('gulp-template');
const rename = require('gulp-rename');

const appBuildFolder = 'app-client/dist';
const moduleFolder = 'corpus_module';
const moduleBuildFolder = 'dist';
const drupalSrcFolder = 'drupal';
const drupalDestFolder = '../build/root/var/www/corpusdelaparole/drupal';
const buildDestFolder = drupalDestFolder + '/sites/all/modules/' + moduleFolder;

const options = minimist(process.argv.slice(2), {string: "version"});

if(!options.version) {
    return process.exit(2);
}

var buildOption = "--prod";
var environment = "production";
var corpusBackUrl = "corpus-back";
if(options.prod) {
    buildOption = "--prod";
    environment = "production";
    corpusBackUrl = "corpus-back";
} else if(options.dev) {
    buildOption = "--dev";
    environment = "development";
    corpusBackUrl = "corpus-app";
}


gulp.task('build-ember', function(cb) {
    exec('npm install', {
        cwd: '../app-client',
        stdio:[0,1,2]
    });
    exec('node_modules/.bin/bower install', {
        cwd: '../app-client',
        stdio:[0,1,2]
    });
    exec('node_modules/.bin/ember build '+buildOption, {
        cwd: '../app-client',
        stdio:[0,1,2]
    });
});

gulp.task('clean', function() {
    return del([
        moduleBuildFolder+'/'+moduleFolder+'/**/*',
        moduleBuildFolder+'/**/*',
    ]);
});
gulp.task('copy-module', function () {
    var moduleFiles = gulp.src([moduleFolder+'/*', '!'+moduleFolder+'/*.tmpl'])
        .pipe(gulp.dest(moduleBuildFolder+'/'+moduleFolder));

    var templateValues = {
        corpus_back_url: corpusBackUrl,
        version: options.version,
        environment: environment
    };
    var tmplModuleFile = gulp.src(moduleFolder+'/corpus.module.tmpl')
        .pipe(template(templateValues))
        .pipe(rename("corpus.module"))
        .pipe(gulp.dest(moduleBuildFolder+'/'+moduleFolder));

    var assetsFiles = gulp.src(appBuildFolder+'/assets/**/*')
        .pipe(gulp.dest(moduleBuildFolder+'/'+moduleFolder+'/app-client/assets'));

    var fontsFiles = gulp.src(appBuildFolder+'/fonts/**/*')
        .pipe(gulp.dest(moduleBuildFolder+'/'+moduleFolder+'/app-client/fonts'));

    return merge(moduleFiles, tmplModuleFile, assetsFiles, fontsFiles);

});
gulp.task('zip-module', function() {
    return gulp.src(moduleBuildFolder+'/'+moduleFolder+'/**/*')
        .pipe(zip(moduleFolder+'.zip'))
        .pipe(gulp.dest(moduleBuildFolder));
})

gulp.task('default', function(cb) {
    seq('clean', 'copy-module', function (err) {
      //if any error happened in the previous tasks, exit with a code > 0
      if (err) {
        var exitCode = 2;
        console.log('[ERROR] gulp build task failed', err);
        console.log('[FAIL] gulp build task failed - exiting with code ' + exitCode);
        return process.exit(exitCode);
      }
      else {
        return cb();
      }
    });
});

gulp.task('zip', function(cb) {
    seq('clean', 'copy-module', 'zip-module', function (err) {
      //if any error happened in the previous tasks, exit with a code > 0
      if (err) {
        var exitCode = 2;
        console.log('[ERROR] gulp build task failed', err);
        console.log('[FAIL] gulp build task failed - exiting with code ' + exitCode);
        return process.exit(exitCode);
      }
      else {
        return cb();
      }
    });
});

gulp.task('do-copy-build', function(cb) {
    return gulp.src(moduleBuildFolder+'/'+moduleFolder+'/**/*')
        .pipe(gulp.dest(buildDestFolder));
});

gulp.task('copy-drupal', function(cb) {
    return gulp.src([drupalSrcFolder+'/**/*', drupalSrcFolder+'/**/.*'])
        .pipe(gulp.dest(drupalDestFolder));
});

gulp.task('copy-build', function(cb) {
    seq('clean', 'copy-module', 'do-copy-build', function (err) {
      //if any error happened in the previous tasks, exit with a code > 0
      if (err) {
        var exitCode = 2;
        console.log('[ERROR] gulp build task failed', err);
        console.log('[FAIL] gulp build task failed - exiting with code ' + exitCode);
        return process.exit(exitCode);
      }
      else {
        return cb();
      }
    });
});
