'use strict';

const path    = require('path');
const Q       = require('q');
const request = require('request');
const _       = require('lodash');
const fs      = require('fs');
const http    = require('http');

const continentGeonamesIds = {
  'africa':        '6255146',
  'asia':          '6255147',
  'europe':        '6255148',
  'north_america': '6255149',
  'australia':		 '6255151',
  'south_america': '6255150',
  'antarctica':    '6255152'
};

const regionsGeonamesIds = {
  'FR-A' : '11071622', // Alsace-Champagne-Ardenne-Lorraine
  'FR-B' : '11071620', // Aquitaine-Limousin-Poitou-Charentes
  'FR-C' : '11071625', // Auvergne-Rhône-Alpes
  'FR-D' : '11071619', // Bourgogne-Franche-Comté
  'FR-E' : '3030293', // Bretagne
  'FR-F' : '3027939', // Centre-Val de Loire
  'FR-G' : '3023519', // Corse
  'FR-H' : '3012874', // Île-de-France
  'FR-I' : '11071623', // Languedoc-Roussillon-Midi-Pyrénées
  'FR-J' : '11071624', // Nord-Pas-de-Calais-Picardie
  'FR-K' : '11071621', // Normandie
  'FR-L' : '2988289', // Pays-de-la-Loire
  'FR-M' : '2985244', // Provence-Alpes-Côte d'Azur
};

const contriesGeonamesIds = {
  "AD": "3041565", "AE": "290557", "AF": "1149361", "AG": "3576396", "AI": "3573511",
  "AL": "783754", "AM": "174982", "AO": "3351879", "AQ": "6697173", "AR": "3865483",
  "AS": "5880801", "AT": "2782113", "AU": "2077456", "AW": "3577279", "AX": "661882",
  "AZ": "587116", "BA": "3277605", "BB": "3374084", "BD": "1210997", "BE": "2802361",
  "BF": "2361809", "BG": "732800", "BH": "290291", "BI": "433561", "BJ": "2395170",
  "BL": "3578476", "BM": "3573345", "BN": "1820814", "BO": "3923057", "BQ": "7626844",
  "BR": "3469034", "BS": "3572887", "BT": "1252634", "BV": "3371123", "BW": "933860",
  "BY": "630336", "BZ": "3582678", "CA": "6251999", "CC": "1547376", "CD": "203312",
  "CF": "239880", "CG": "2260494", "CH": "2658434", "CI": "2287781", "CK": "1899402",
  "CL": "3895114", "CM": "2233387", "CN": "1814991", "CO": "3686110", "CR": "3624060",
  "CU": "3562981", "CV": "3374766", "CW": "7626836", "CX": "2078138", "CY": "146669",
  "CZ": "3077311", "DE": "2921044", "DJ": "223816", "DK": "2623032", "DM": "3575830",
  "DO": "3508796", "DZ": "2589581", "EC": "3658394", "EE": "453733", "EG": "357994",
  "EH": "2461445", "ER": "338010", "ES": "2510769", "ET": "337996", "FI": "660013",
  "FJ": "2205218", "FK": "3474414", "FM": "2081918", "FO": "2622320", "FR": "3017382",
  "GA": "2400553", "GB": "2635167", "GD": "3580239", "GE": "614540", "GF": "3381670",
  "GG": "3042362", "GH": "2300660", "GI": "2411586", "GL": "3425505", "GM": "2413451",
  "GN": "2420477", "GP": "3579143", "GQ": "2309096", "GR": "390903", "GS": "3474415",
  "GT": "3595528", "GU": "4043988", "GW": "2372248", "GY": "3378535", "HK": "1819730",
  "HM": "1547314", "HN": "3608932", "HR": "3202326", "HT": "3723988", "HU": "719819",
  "ID": "1643084", "IE": "2963597", "IL": "294640", "IM": "3042225", "IN": "1269750",
  "IO": "1282588", "IQ": "99237", "IR": "130758", "IS": "2629691", "IT": "3175395",
  "JE": "3042142", "JM": "3489940","JO": "248816", "JP": "1861060", "KE": "192950",
  "KG": "1527747", "KH": "1831722", "KI": "4030945", "KM": "921929", "KN": "3575174",
  "KP": "1873107", "KR": "1835841", "XK": "831053", "KW": "285570", "KY": "3580718",
  "KZ": "1522867", "LA": "1655842", "LB": "272103", "LC": "3576468", "LI": "3042058",
  "LK": "1227603", "LR": "2275384", "LS": "932692", "LT": "597427", "LU": "2960313",
  "LV": "458258", "LY": "2215636", "MA": "2542007", "MC": "2993457", "MD": "617790",
  "ME": "3194884", "MF": "3578421", "MG": "1062947", "MH": "2080185", "MK": "718075",
  "ML": "2453866", "MM": "1327865", "MN": "2029969", "MO": "1821275", "MP": "4041468",
  "MQ": "3570311", "MR": "2378080", "MS": "3578097", "MT": "2562770", "MU": "934292",
  "MV": "1282028", "MW": "927384", "MX": "3996063", "MY": "1733045", "MZ": "1036973",
  "NA": "3355338", "NC": "2139685", "NE": "2440476", "NF": "2155115", "NG": "2328926",
  "NI": "3617476", "NL": "2750405", "NO": "3144096", "NP": "1282988", "NR": "2110425",
  "NU": "4036232", "NZ": "2186224", "OM": "286963", "PA": "3703430", "PE": "3932488",
  "PF": "4030656", "PG": "2088628", "PH": "1694008","PK": "1168579", "PL": "798544",
  "PM": "3424932", "PN": "4030699", "PR": "4566966", "PS": "6254930", "PT": "2264397",
  "PW": "1559582", "PY": "3437598","QA": "289688", "RE": "935317", "RO": "798549",
  "RS": "6290252", "RU": "2017370", "RW": "49518", "SA": "102358", "SB": "2103350",
  "SC": "241170", "SD": "366755", "SS": "7909807", "SE": "2661886", "SG": "1880251",
  "SH": "3370751", "SI": "3190538", "SJ": "607072", "SK": "3057568", "SL": "2403846",
  "SM": "3168068", "SN": "2245662", "SO": "51537", "SR": "3382998", "ST": "2410758",
  "SV": "3585968", "SX": "7609695", "SY": "163843", "SZ": "934841", "TC": "3576916",
  "TD": "2434508", "TF": "1546748", "TG": "2363686", "TH": "1605651", "TJ": "1220409",
  "TK": "4031074", "TL": "1966436", "TM": "1218197", "TN": "2464461", "TO": "4032283",
  "TR": "298795", "TT": "3573591", "TV": "2110297", "TW": "1668284", "TZ": "149590",
  "UA": "690791", "UG": "226074", "UM": "5854968", "US": "6252001", "UY": "3439705",
  "UZ": "1512440", "VA": "3164670", "VC": "3577815", "VE": "3625428", "VG": "3577718",
  "VI": "4796775", "VN": "1562822", "VU": "2134431", "WF": "4034749", "WS": "4034894",
  "YE": "69543", "YT": "1024031", "ZA": "953987", "ZM": "895949", "ZW": "878675",
  "CS": "8505033", "AN": "8505032"
}

const missingTerritories = [
  "PF", //"French Polynesia",
  "RE", //"Reunion",
  "YT", //"Mayotte",
  "MU", //"Mauritius",
  "WF", //"Wallis and Futuna",
  "TF", //"French Southern and Antarctic Lands",
  "MF", //"Saint Martin",
  "BL", //"Saint Barthelemy",
  "PM", //"Saint Pierre and Miquelon",
  "GP", //"Guadeloupe",
  "MQ", //"Martinique",
];

global.AmCharts = {'maps': {
  'worldLow': null,
  'worldHigh': null,
  'continentsLow': null,
  'france2016Low': null
}};

require(path.join(__dirname,'..','..', 'bower_components/ammap3/ammap/maps/js/worldLow.js'));
require(path.join(__dirname,'..','..', 'bower_components/ammap3/ammap/maps/js/worldHigh.js'));
require(path.join(__dirname,'..','..', 'bower_components/ammap3/ammap/maps/js/continentsLow.js'));
require(path.join(__dirname,'..','..', 'bower_components/ammap3/ammap/maps/js/france2016Low.js'));


const geonamesUsername = process.argv[2];

http.globalAgent.maxSockets = 20;

function requestq(url) {
  var deferred = Q.defer();
  request(url, (error, resp, body) => {
    if (!error && resp.statusCode == 200) {
      deferred.resolve(body);
    } else {
      deferred.reject(error, resp);
    }
  });
  return deferred.promise;
}

function convertPathId(map, ids) {
  return Q.all(_.map(map['svg']['g']['path'], (path) => {
    let geonamesId = ids[path['id']];
    return requestq("http://api.geonames.org/getJSON?formatted=true&geonameId="+geonamesId+"&username="+geonamesUsername+"&style=full").then((body)=>{
      let geoInfo = JSON.parse(body);
      let name = null;
      _.each(geoInfo["alternateNames"], (alName) => {
        if(alName['lang'] == 'fr' && (alName['isPreferredName'] || name == null) && !alName['isHistoric']) {
          name = alName['name'];
        }
      });
      name = name || path['title'];
      return _.defaults( { 'id': geonamesId, 'title': name } ,path );
    });
  })).then((paths) => {
    map['svg']['g']['path'] = paths;
    return map;
  });
}

function findInMap(id, map) {
  const resList = _.filter(map['svg']['g']['path'], function(pathDef) {
    return pathDef.id === id;
  })
  return (resList && resList.length)?resList[0]:null;
}

function copyMissingterritories() {
  _.each(missingTerritories, function(id) {
    if(findInMap(id, AmCharts.maps.worldLow) === null) {
      let pathDef = findInMap(id, AmCharts.maps.worldHigh);
      if(pathDef !== null) {
        AmCharts.maps.worldLow['svg']['g']['path'].push(_.cloneDeep(pathDef));
      }
    }
  });
}


copyMissingterritories();

convertPathId(AmCharts.maps.france2016Low, regionsGeonamesIds).then((map)=> {
  fs.writeFileSync(
    path.join(__dirname,'..','..','vendor/data/maps/france2016Low.js'),
    "AmCharts.maps.france2016Low=" + JSON.stringify(map, null, '\t')
  );
}).done();

convertPathId(AmCharts.maps.continentsLow, continentGeonamesIds).then((map)=> {
  fs.writeFileSync(
    path.join(__dirname,'..','..','vendor/data/maps/continentsLow.js'),
    "AmCharts.maps.continentsLow=" + JSON.stringify(map, null, '\t')
  );
}).done();

convertPathId(AmCharts.maps.worldLow, contriesGeonamesIds).then((map)=> {
  fs.writeFileSync(
    path.join(__dirname,'..','..','vendor/data/maps/worldLow.js'),
    "AmCharts.maps.worldLow=" + JSON.stringify(map, null, '\t')
  );
}).done();


// fs.writeFileSync(
//   path.join(__dirname,'..','..','vendor/data/maps/continentsLow.js'),
//   "AmCharts.maps.continentsLow=" + JSON.stringify(convertPathId(AmCharts.maps.continentsLow, continentGeonamesIds), null, '\t')
// );

// fs.writeFileSync(
//   path.join(__dirname,'..','..','vendor/data/maps/worldLow.js'),
//   "AmCharts.maps.worldLow=" + JSON.stringify(convertPathId(AmCharts.maps.worldLow, contriesGeonamesIds), null, '\t')
// );
