@extends('app')

@section('content')
<div class="container">
	<div class="row">
		<div class="col-md-10 col-md-offset-1">
			<div class="panel panel-default">
				<div class="panel-heading">@lang('bo.document_detail')</div>

				<div class="panel-body">
					<div class="doc_details">
						<div class="data">
							<div class="data-audio-title">@lang('bo.document_audio')</div>
							<div class="data-audio-player">
								<audio id='' controls="controls">
								@foreach ($doc->getMediaArray() as $audio)
									<source src="{{ $audio['url'] }}" type="{{ $audio['format']}}"/>
								@endforeach
									Your browser does not support the audio tag
								</audio>
							</div>
						</div>
						<div class="content">
							<div class="data-content-title">@lang('bo.document_content')</div>
							<div class="desc">@lang('bo.document_title')</div>
							<div class="value">{{$doc->getTitle()}} ({{$doc->getTitle()->getLang()}})</div>
							<div class="desc">@lang('bo.document_editors')</div>
							<div class="value">@foreach ($doc->getPublishers() as $index => $publisher){{ $index>0?", ":"" }}{{$publisher}}@endforeach</div>
							<div class="desc">@lang('bo.document_types')</div>
							<div class="value">@foreach ($doc->getOtherTypes() as $index => $type){{ $index>0?", ":"" }}{{$type}}@endforeach</div>
							<div class="desc">@lang('bo.document_discourse_types')</div>
							<div class="value">
							@foreach ($doc->getDiscourseTypes() as $index => $type)
								<select name='discourse_type[]' id='discourse-type' form='graph-form'>
								@foreach (Config::get('constants.OLAC_DISCOURSE_TYPE')['values'] as $index => $type_discourse)
								    <option value='{{$type_discourse['code']}}' {{$type==$type_discourse['code']?'selected':''}}>@lang('bo.discourse_type_'.$type_discourse['code'])</options>
								@endforeach
								</select>
							@endforeach
								<select name='discourse_type[]' id='discourse-type' form='graph-form'>
								@foreach (Config::get('constants.OLAC_DISCOURSE_TYPE')['values'] as $index => $type_discourse)
									<option value='{{$type_discourse['code']}}'>@lang('bo.discourse_type_'.$type_discourse['code'])</options>
								@endforeach
								</select>
							</div>
						</div>
					</div>
					<div id="graph_form_wrapper">
						{!! Form::open(['route'=>['bo.docs.update', $doc->getId()], 'id'=>'graph-form', 'class' => 'doc-form', 'method' => 'PUT']) !!}
						{!! Form::submit('Ok') !!}
						{!! Form::close() !!}
					</div>
					<pre>{{ $doc->getGraph()->dump('text') }}</pre>
				</div>
			</div>
		</div>
	</div>
</div>
@endsection

<!--
<table class="meta">
                <tbody><tr class="right">
                    <td colspan="2">Identifiant OAI: <a title="métadonnées XML/OLAC" target="_blank" href="/crdo_servlet/oai-pmh?verb=GetRecord&amp;identifier=oai:crdo.vjf.cnrs.fr:crdo-ALA_608&amp;metadataPrefix=olac">oai:crdo.vjf.cnrs.fr:crdo-ALA_608</a>
                    </td>
                </tr>
                <tr class="right">
                    <td colspan="2">PURL: <a title="permalien" href="http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-ALA_608">http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-ALA_608</a>
                    </td>
                </tr>
                <tr class="right">
                    <td colspan="2">ARK: <a title="permalien" href="/exist/crdo/ark:/87895/1.17-467712">http://cocoon.huma-num.fr/exist/crdo/ark:/87895/1.17-467712</a>
                    </td>
                </tr>
                <tr class="right">
                    <td colspan="2">Dernière modification de la notice: 2014-11-04 v1.1</td>
                </tr>
                <tr>
                    <td class="rubrique" colspan="2">Data</td>
                </tr>
                <tr>
                    <td class="descripteur">Audio</td>
                    <td class="valeur">
                        <audio id="player" controls="controls">
                            <source type="audio/mpeg" src="http://cocoon.huma-num.fr/data/ala/ALA_608.mp3">
                            <source type="audio/x-wav" src="http://cocoon.huma-num.fr/data/ala/ALA_608_22km.wav">
						Your browser does not support the audio tag
					</audio>
                    </td>
                </tr>
                <tr>
                    <td class="rubrique" colspan="2">Description du contenu</td>
                </tr>
                <tr>
                    <td class="descripteur">Titre:</td>
                    <td class="valeur">[fr] Atlas Linguistique et ethnographique de l'Alsace - Enquetes sur la conscience linguistique - ALA_608</td>
                </tr>
                <tr>
                    <td class="descripteur">Editeur(s):</td>
                    <td class="valeur">
                        <a title="rechercher toutes les ressources de cet éditeur" href="/exist/crdo/rechercher.xql?terme=%22Atlas%20linguistiques%2C%20cultures%20et%20parlers%20r%C3%A9gionaux%20de%20France%22&amp;field=Publisher">Atlas linguistiques, cultures et parlers régionaux de France</a>
                        <a title="en savoir plus sur ce participant" href="/exist/crdo/organisations.xql?code=crdo:/vocabulary/org/GRECO9">
                            <img src="/exist/crdo/img/plus.png" alt="n.c">
                        </a>
                    </td>
                </tr>
                <tr>
                    <td class="descripteur">Participant(s):</td>
                    <td class="valeur">
                        <a title="rechercher toutes les ressources de ce participant" href="/exist/crdo/rechercher.xql?terme=%22Huck%2C%20Dominique%22&amp;field=Contributor">Huck, Dominique</a>
                        (depositor, interviewer)
                        <a title="en savoir plus sur ce participant" href="/exist/crdo/organisations.xql?code=http://viaf.org/viaf/9122216">
                            <img src="/exist/crdo/img/plus.png" alt="n.c">
                        </a>
                        <br>
                        <a title="rechercher toutes les ressources de ce participant" href="/exist/crdo/rechercher.xql?terme=%22Bothorel-Witz%2C%20Arlette%22&amp;field=Contributor">Bothorel-Witz, Arlette</a>
                        (interviewer)
                        </td>
                </tr>
                <tr>
                    <td class="descripteur">Description(s):</td>
                    <td class="valeur">[fr] Extrait des enquêtes dialectologiques en vue de constituer un atlas linguistique de l'Alsace.</td>
                </tr>
                <tr>
                    <td class="descripteur">Couverture spatiale:</td>
                    <td class="valeur">[fr] France, Alsace<br>Pays/région (ISO-3166): France<a href="/exist/crdo/geonames.xql?code=FR" title="voir plus d'informations sur ce code pays ou cette région">
                            <img src="/exist/crdo/img/plus.png" alt="n.c">
                        </a>
                    </td>
                </tr>
                <tr>
                    <td class="descripteur">Date(s):</td>
                    <td class="valeur">création: start=1980; end=1989; name=années 80<br>mise à disposition: 2004-07-03<br>archivage: 2014-11-04T16:25:54+01:00</td>
                </tr>
                <tr>
                    <td class="descripteur">Type(s):</td>
                    <td class="valeur">
                        <a target="_blank" href="http://www.language-archives.org/REC/type.html" title="voir la définition des types linguistiques sur OLAC">Type(s) linguistique</a>:     				primary_text<br>
                        <a target="_blank" href="http://www.language-archives.org/REC/discourse.html" title="voir la définition des types de discours sur OLAC">Type(s) de discours</a>:
					dialogue<br>Enregistrement sonore</td>
                </tr>
                <tr>
                    <td class="descripteur">Sujet(s):</td>
                    <td class="valeur">
                        <a target="_blank" href="http://www.language-archives.org/REC/field.html" title="voir la définition des champs linguistiques sur OLAC">Champ(s) linguistique</a>:
					    lexicography, phonetics, anthropological_linguistics<br>Alsacien (code ISO-639: gsw<a href="/exist/crdo/lexvo.xql?code=gsw" title="en savoir plus sur ce code de langue">
                            <img src="/exist/crdo/img/plus.png" alt="n.c">
                        </a>)</td>
                </tr>
                <tr>
                    <td class="descripteur">Langue(s):</td>
                    <td class="valeur">[fr] Alsacien (code ISO-639: gsw<a href="/exist/crdo/lexvo.xql?code=gsw" title="en savoir plus sur ce code de langue">
                            <img src="/exist/crdo/img/plus.png" alt="n.c">
                        </a>)</td>
                </tr>
                <tr>
                    <td class="descripteur">Format(s):</td>
                    <td class="valeur">
			(IANA MIME Media Type: <a target="_blank" href="http://www.iana.org/assignments/media-types/audio" title="voir les informations sur IANA">audio/x-wav</a>)
		<br>
			durée: 0:02H04:16</td>
                </tr>
                <tr>
                    <td class="rubrique" colspan="2">Description de l'accès</td>
                </tr>
                <tr>
                    <td class="descripteur">Droits:</td>
                    <td class="valeur">Copyright (c) Département de dialectologie alsacienne et mosellane de l'Université de Strasbourg<br>Freely available for non-commercial use<br>
					Le document est soumis à la
					<a target="_blank" href="http://creativecommons.org/licenses/by-nc-nd/2.5/" title="Creative Commons License">Licence Creative Commons
						<img src="http://creativecommons.org/images/public/somerights20.png" alt="n.c">
                        </a>
                    </td>
                </tr>
                <tr>
                    <td class="descripteur">Document(s):</td>
                    <td class="valeur">
                        <form action="/media-meta.php" method="get" target="_blank">
                            <select name="file">
                                <option value="ala/ALA_608_22km.wav">Format de diffusion (.wav)</option>
                                <option value="ala/ALA_608.mp3">Format de diffusion (.mp3)</option>
                            </select>
                            <input alt="télécharger" src="/exist/crdo/img/download.png" type="image" name="submit" title="Télécharger">
                            <input type="checkbox" name="metadata"> encapsuler les métadonnées
							<input type="hidden" name="id" value="crdo-ALA_608">
                        </form>
                        <div>
								Le format de conservation (.wav)
								<a href="http://cocoon.huma-num.fr/data/ala/masters/ALA_608.wav" target="_blank">
                                <img alt="n.c" src="/exist/crdo/img/download.png" title="Télécharger">
                            </a>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td class="descripteur">Relation(s):</td>
                    <td class="valeur">Est une partie de la collection <a href="/exist/crdo/meta/crdo-COLLECTION_ALA_CL" title="voir la notice de la ressource">Atlas Linguistique et ethnographique de l'Alsace: Enquêtes sur la conscience linguistique</a>
                        <br>Est une partie de la collection <a href="/exist/crdo/meta/crdo-COLLECTION_LANGUESDEFRANCE" title="voir la notice de la ressource">Corpus de la parole</a>
                    </td>
                </tr>
            </tbody></table>
-->
