import Ember from 'ember';

export default Ember.Component.extend({

    classNames: ['transcript-component'],

    player: Ember.inject.service(),

    autoscroll: true,
    autoscrollElement : Ember.$('.corpus-app-container'),

    itemObserver: Ember.observer('player.item', function () {
        this.set('autoscroll', true);
    }),

    init: function() {
        var self = this;
        this.get('autoscrollElement').bind('scroll', function() {
            self.set('autoscroll', false);
        });

        this._super(...arguments);
    },

    didUpdate: function() {
        if(this.get('autoscroll')) {
            this.get('autoscrollElement').scrollTop((Ember.$('.sentence.active').offset().top + this.get('autoscrollElement').scrollTop()) - this.get('autoscrollElement').offset().top)
        }
    }

});
