class sysconfig::drupal (
    $vhost = hiera('sysconfig::params::vhost', $sysconfig::params::vhost)
) inherits sysconfig::params {

    notify {'drupal': name => "drupal => \$vhost : ${vhost}", withpath => true }

    #install composer
    file { "/tmp/composer":
        ensure => directory,
    }->
    file { "/tmp/composer/install.sh":
        mode => "0755",
        source => "puppet:///modules/sysconfig/composer/install.sh",
    }->
    exec { "install_composer":
        command => "/tmp/composer/install.sh",
        creates => "/usr/local/bin/composer"
    }->

    class { '::drush':
        require               => Package["php56"],
        versions              => ['7'],
        default_version       => '7',
        autoupdate            => true,
        ensure_extra_packages => false,
        extra_packages        => [ 'bzip2', 'gzip', 'less', 'mariadb', 'rsync', 'unzip', 'wget' ],
        extensions            => ['drush_extras'],
        php_path              => '/opt/remi/php56/root/usr/bin/php',
        composer_path         => '/opt/remi/php56/root/usr/bin/php /usr/local/bin/composer'
    }

    drush::alias { 'corpus':
        root => '/var/www/corpusdelaparole/drupal',
        uri  => $vhost,
    }

}
