<?php

namespace CorpusParole\Http\Controllers\Bo;

use Config;
use Log;

use CorpusParole\Http\Controllers\Controller;
use CorpusParole\Repositories\DocumentRepository;
use CorpusParole\Services\LexvoResolverInterface;

use Illuminate\Http\Request;

class DocumentListController extends Controller {

    /**
     * Create a new controller instance.
     */
    public function __construct(DocumentRepository $documentRepo, LexvoResolverInterface $lexvoResolver) {
        $this->documentRepository = $documentRepo;
        $this->lexvoResolver = $lexvoResolver;
    }

    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index() {
        $docs = $this->documentRepository->paginate();
        $languageIds = [];
        foreach ($docs as $doc) {
            foreach($doc->getLanguagesValue() as $langId) {
                array_push($languageIds, $langId);
            }
        }
        $languageNames = $this->lexvoResolver->getNames(array_unique($languageIds));
        return view('bo.docList', ['docs' => $docs, 'languageNames' => $languageNames]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @return Response
     */
    public function store()
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param string $id
     *
     * @return Response
     */
    public function show($id)
    {
        Log::info("show: $id");
        //$doc->add("<$doc_uri>");
        $doc = $this->documentRepository->get($id);

        if(is_null($doc)) {
            abort(404);
        }

        return view('bo.docDetail', ['doc' => $doc]);

    }

    /**
     * Display the specified resource with the js client.
     *
     * @param string $id
     *
     * @return Response
     */
    public function getClient($id)
    {
        Log::info("getClient: $id");
        return view('bo.docDetailClient', ['docid' => $id, 'boClientEnv' => json_encode(config('corpusparole.bo_client_environment'), JSON_UNESCAPED_SLASHES)]);
    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     *
     * @return Response
     */
    public function edit($id)
    {
        $doc = $this->documentRepository->get($id);

        return view('bo.docEdit', ['doc' => $doc]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param int $id
     *
     * @return Response
     */
    public function update($id, Request $request)
    {
        $doc = $this->documentRepository->get($id);

        $newDoc = clone $doc;

        $newDoc->updateDiscourseTypes(array_unique($request->input('discourse_type')));

        //TODO: save change in store
        //TODO: create log object

        return redirect()->route('bo.docs.show', ['id' => $id]);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     *
     * @return Response
     */
    public function destroy($id)
    {
        //
    }
}
