import Ember from 'ember';

export default Ember.Controller.extend({
  queryParams: ['location', 'langue'],
  location: null,
  langue: null,
  filteredSounds: Ember.computed('location', 'langue', 'model', function() {
    var location = this.get('location');
    var langue = this.get('langue');
    var sounds = this.get('model');

    if (location) {
      sounds = sounds.filterBy('location', location);
    }

    if (langue) {
      sounds = sounds.filterBy('language', langue);
    }

    return sounds;
  })
});
