/*jshint node:true*/
module.exports = function(app) {
  var express = require('express');
  var _ = require('lodash');

  var v1ViafRouter = express.Router();

  var viafMappings = require('../fixtures/viaf');

  v1ViafRouter.get('/:id', function(req, res) {
    var idList = req.params.id.split(',');
    res.send({
      'viafids': _.reduce(idList, function(r, id) {
        r[id] = (id in viafMappings)?viafMappings[id]:null;
        return r;
      }, {}),
    });
  });

  app.use('/api/v1/viaf', v1ViafRouter);
};
