class sysconfig::elasticsearch (
    $es_host     = hiera('sysconfig::params::es_host', $sysconfig::params::es_host),
    $es_port     = hiera('sysconfig::params::es_port', $sysconfig::params::es_port),
    $es_instance = hiera('sysconfig::params::es_instance', $sysconfig::params::es_instance),
) inherits sysconfig::params {

    notify {'elasticsearch': name => "\$es_host : ${es_host}, \$es_port : ${es_port}, \$es_instance : ${es_instance}", withpath => true }


    class { '::elasticsearch':
      manage_repo  => true,
      autoupgrade => true,
      repo_version => '2.x',
    }->
    elasticsearch::instance { $es_instance: }
}
