<?php

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It's a breeze. Simply tell Laravel the URIs it should respond to
| and give it the controller to call when that URI is requested.
|
*/

Route::get('/', 'WelcomeController@index');

Route::get('home', 'HomeController@index');

//Route::get('bo/docs/docDetailClient', 'Bo\DocumentListController@showClient');
Route::resource('bo/docs', 'Bo\DocumentListController');
Route::controller('bo/docs', 'Bo\DocumentListController', [
    'getClient' => 'bo.docs.client'
]);


Route::controllers([
//    'auth' => 'Auth\AuthController',
    'password' => 'Auth\PasswordController',
]);

/*
|--------------------------------------------------------------------------
| Api Route
|--------------------------------------------------------------------------
|
|
*/

Route::group(['prefix' => 'api/v1', 'middleware' => 'cors'] , function() {
    Route::resource('documents', 'Api\DocumentController',
                    ['only' => ['index', 'show', 'update']]);
    Route::resource('viaf', 'Api\ViafController',
                    ['only' => ['show']]);
    Route::resource('lexvo', 'Api\LexvoController',
                    ['only' => ['show']]);
    Route::resource('languages', 'Api\LanguageController',
                    ['only' => ['index']]);
});
