<?php

class GeoStatsControllerTest extends TestCase
{
   public function testGetIndex()
    {
        $query = [
            'index' => env('ELASTICSEARCH_INDEX'),
            'body' => [
                "size" => 0,
                "query" => [
                    'match_all' => []
                ],
                "aggs" => [
                    "geos" => [
                        "terms" => [
                            "size" => 0,
                            "field" => "geonames_hierarchy"
                        ]
                    ]
                ]
            ]
        ];

        Es::shouldReceive('search')
                    ->once()
                    ->with($query)
                    ->andReturn(json_decode("{
  \"took\" : 17,
  \"timed_out\" : false,
  \"_shards\" : {
    \"total\" : 1,
    \"successful\" : 1,
    \"failed\" : 0
  },
  \"hits\" : {
    \"total\" : 3011,
    \"max_score\" : 0.0,
    \"hits\" : [ ]
  },
  \"aggregations\" : {
    \"geos\" : {
      \"doc_count_error_upper_bound\" : 0,
      \"sum_other_doc_count\" : 0,
      \"buckets\" : [ {
        \"key\" : 6255148,
        \"doc_count\" : 2684
      }, {
        \"key\" : 3017382,
        \"doc_count\" : 2674
      }, {
        \"key\" : 3027939,
        \"doc_count\" : 851
      } ]
    }
  }
}", true));

        $this->get('/api/v1/stats/geostats/')->assertTrue($this->response->isOk(), $this->response->content());
        $this->seeJsonEquals(["geostats" => [
            '6255148' => 2684,
            '3017382' => 2674,
            '3027939' => 851
        ]]);
    }


    public function testGetIndexEarth()
    {
        $query = [
            'index' => env('ELASTICSEARCH_INDEX'),
            'body' => [
                "size" => 0,
                "query" => [
                    'match_all' => []
                ],
                "aggs" => [
                    "geos" => [
                        "terms" => [
                            "size" => 0,
                            "field" => "geonames_hierarchy"
                        ]
                    ]
                ]
            ]
        ];

        Es::shouldReceive('search')
                ->once()
                ->with($query)
                ->andReturn(json_decode("{
  \"took\" : 17,
  \"timed_out\" : false,
  \"_shards\" : {
    \"total\" : 1,
    \"successful\" : 1,
    \"failed\" : 0
  },
  \"hits\" : {
    \"total\" : 3011,
    \"max_score\" : 0.0,
    \"hits\" : [ ]
  },
  \"aggregations\" : {
    \"geos\" : {
      \"doc_count_error_upper_bound\" : 0,
      \"sum_other_doc_count\" : 0,
      \"buckets\" : []
    }
  }
}", true));

        $this->get('/api/v1/stats/geostats/?area='.config('corpusparole.geonames_earth_geonamesid'))->assertTrue($this->response->isOk(), $this->response->content());
    }


    public function testGetIndexArea()
    {

        $query = [
            "index" => env('ELASTICSEARCH_INDEX'),
            "body" => [
                "size" => 0,
                "query" => [
                    "constant_score" => [
                        "filter" => [
                            "bool" => [
                                "must" => [ [
                                    "term" => [ "geonames_hierarchy" => "code_area" ]
                                ] ]
                            ]
                        ]
                    ]
                ],
                "aggs" => [
                    "geos" => [
                        "terms" => [
                            "size" => 0,
                            "field" => "geonames_hierarchy"
                        ]
                    ]
                ]
            ]
        ];

        Es::shouldReceive('search')
                ->once()
                ->with($query)
                ->andReturn(json_decode("{
  \"took\" : 17,
  \"timed_out\" : false,
  \"_shards\" : {
    \"total\" : 1,
    \"successful\" : 1,
    \"failed\" : 0
  },
  \"hits\" : {
    \"total\" : 3011,
    \"max_score\" : 0.0,
    \"hits\" : [ ]
  },
  \"aggregations\" : {
    \"geos\" : {
      \"doc_count_error_upper_bound\" : 0,
      \"sum_other_doc_count\" : 0,
      \"buckets\" : []
    }
  }
}", true));

        $this->get('/api/v1/stats/geostats/?area=code_area')->assertTrue($this->response->isOk(), $this->response->content());
    }

}
