import Ember from 'ember';
import * as utils from 'corpus-common-addon/utils/utils';
import layout from '../templates/components/doc-location';

export default Ember.Component.extend({
  layout: layout,
  tagName: 'span',

  geonamesResolver: Ember.inject.service(),

  _resolveGeonamesIds: Ember.on('init', Ember.observer('url', function () {
    this.get('geonamesResolver').getLabel(this.get('url'))
      .then(function (str) {
        this.set('resolvedLabel', str);
      }.bind(this));
  })),

  code: Ember.computed('url', function () {
    return utils.getGeonamesCode(this.get('url'));
  }),
  isLocationLink: Ember.computed.match('url', /^http:\/\//)

});
