/* jshint node: true */

module.exports = function(environment) {
    var ENV = {
        rootElement: '#corpus-app',
        modulePrefix: 'app-client',
        environment: environment,
        rootURL: '/corpus/',
        locationType: 'hash',
        EmberENV: {
            FEATURES: {
                // Here you can enable experimental features on an ember canary build
                // e.g. 'with-controller': true
            }
        },
        APP: {
            backRootURL: '/corpus/',
            // Here you can pass flags/options to your application instance
            // when it is created
        }
    };
    if (environment === 'development') {
        ENV.contentSecurityPolicy = {
            'default-src': "'none'",
            'script-src': "'self' *",
            'font-src': "'self'",
            'connect-src': "'self' *",
            'img-src': "'self'",
            'style-src': "'self' *",
            'media-src': "'self'"
        };
    }
    if (environment === 'test') {
        ENV.rootURL = '/';
        ENV.locationType = 'none';
        ENV.APP.LOG_ACTIVE_GENERATION = false;
        ENV.APP.LOG_VIEW_LOOKUPS = false;
        ENV.APP.rootElement = '#ember-testing';
        ENV.APP.backRootURL = '/';
    }

    if (environment === 'production') {
        ENV.rootURL = '/corpus-app/';
        ENV.APP.backRootURL = '/corpus-back/';
    }

    return ENV;
};
