import Ember from 'ember';
import _ from 'lodash/lodash';

const FILTER_QUERY_PARAMS = ['date', 'discourse', 'language', 'location', 'theme'];

export default Ember.Service.extend({

    date: null,
    discourse: null,
    language: null,
    location: null,
    theme: null,

    queryParams: FILTER_QUERY_PARAMS,

    queryParamsValues: Ember.computed('date', 'discourse', 'language', 'location', 'theme', function() {
        return this.getProperties(FILTER_QUERY_PARAMS);
    }),
    removeFilter: function(filter, value) {
        switch(filter) {
            case 'date':
            case 'discourse':
            case 'theme':
                let values = this.get(filter);
                if(values === null) {
                    return;
                }
                values = _.without(values, value);
                if(values.length === 0) {
                    this.set(filter, null);
                } else {
                    this.set(filter, values);
                }
                break;
            case 'language':
            case 'location':
                this.set(filter, null);
                break;
        }
    },
    setFilter: function(filter, value) {
        switch(filter) {
            case 'date':
            case 'discourse':
            case 'theme':
                let filterValues = this.get(filter);
                console.log("filterValues", filterValues);
                if(filterValues === null) {
                    filterValues = [];
                }
                if(!_.contains(filterValues, value)) {
                    filterValues = filterValues.slice(0);
                    filterValues.push(value);
                    filterValues.sort();
                    this.set(filter, filterValues);
                }
                break;
            case 'language':
            case 'location':
                if(this.get(filter) !== value) {
                    this.set(filter, value);
                }
                break;
        }
    },
    serializeQueryParam(value/*, urlKey, defaultValueType*/) {
        if (_.isArray(value)) {
          return value;
        }
        return `${value}`;
    },
    deserializeQueryParam(value, urlKey, defaultValueType) {
        if (urlKey === 'date' || urlKey === 'theme' || urlKey === 'discourse') {
            if(_.isArray(value)) {
                return value;
            } else {
                var parsedValue = Ember.A(JSON.parse(value));
                if (_.isArray(parsedValue)) {
                    return parsedValue;
                } else {
                    return Ember.A([ parsedValue, ]);
                }
            }
        } else if (defaultValueType === 'boolean') {
            return (value === 'true') ? true : false;
        } else if (defaultValueType === 'number') {
            return (Number(value)).valueOf();
        } else if (defaultValueType === 'array') {
            return Ember.A(JSON.parse(value));
        }
        return value;
    }

});
