import Ember from 'ember';
import _ from 'lodash/lodash';

export default Ember.Route.extend({

    filter: Ember.inject.service(),
    page: 1,
    limit: 10,

    documents: [],
    model: Ember.observer('page', function() {
        var self = this;
        var promise = this.store.query('document', {
            page: this.get('page'),
            perpage: this.get('limit')
        });
        promise.then(function(value) {
            if(self.controller) {
                self.controller.set('page', self.get('page'));
                self.controller.set('documents', self.get('documents'));
            }
            self.set('documents', value);
        });
        return promise;
    }),

    setupController: function(controller) {
        this._super(...arguments);
        controller.set('page', this.get('page'));
        controller.set('limit', this.get('limit'));
        controller.set('documents', this.get('documents'));
    },

    /**
      Serializes value of the query parameter based on defaultValueType
      @method serializeQueryParam
      @param {Object} value
      @param {String} urlKey
      @param {String} defaultValueType
      @private
    */
    serializeQueryParam(value, urlKey, defaultValueType) {
        if(_.contains(this.get('filter').get('queryParams'), urlKey)) {
            return this.get('filter').serializeQueryParam(value, urlKey, defaultValueType);
        }
        return this._super(value, urlKey, defaultValueType);
    },

    /**
      Deserializes value of the query parameter based on defaultValueType
      @method deserializeQueryParam
      @param {Object} value
      @param {String} urlKey
      @param {String} defaultValueType
      @private
    */
    deserializeQueryParam(value, urlKey, defaultValueType) {
        if(_.contains(this.get('filter').get('queryParams'), urlKey)) {
            return this.get('filter').deserializeQueryParam(value, urlKey, defaultValueType);
        }
        return this._super(value, urlKey, defaultValueType);
    },


    actions: {

        setPageQueryparams: function(type) {
            var page = this.get('page');
            if(type === 'previous') {
                page = page - 1;
            } else if(type === 'next') {
                page = page + 1;
            }
            this.propertyWillChange('page');
            this.set('page', page);
            this.propertyDidChange('page');
        },


        willTransition: function() {
            // Prevent navigation from removing query parameters
            this.transitionTo({ queryParams: this.controller.get('queryParams') });
        },

        didTransition: function() {
            // Append body classname depending on the route
            Ember.$('body').removeClass((this.controller.get('currentPath') || '').replace(/\//g, '-').dasherize());
            Ember.run.once(this, function() {
                Ember.$('body').addClass((this.controller.get('currentPath') ||'').replace(/\//g, '-').dasherize());
            });
        }

    }

});
