import Ember from 'ember';
import _ from 'lodash/lodash';

export default Ember.Component.extend({

    range: [],

    decades: Ember.computed('range', function() {
        var range = this.get('range');
        return _.range(Math.floor(range[0]/10)*10, Math.floor(range[1]/10)*10, 10);
    }),

    filter: Ember.inject.service(),

    dateObserver: Ember.observer('date', function() {
        var self = this;
        this.$('li').removeClass('highlighted');
        this.get('date').forEach(function(date) {
            self.$('li#' + date).addClass('highlighted');
        });
    }),

    date: Ember.computed('filter.date', {
        get: function() {
            const dates = this.get('filter').get('date');
            console.log("get DATES", dates);
            if(dates === null) {
                return [];
            }
            const res = _.reduce(dates, function(res, d) {
                let m = d.match(/^(\d+)(?:-(\d+))?$/);
                if(m) {
                    let start = parseInt(m[1]);
                    let end = parseInt(m[2]);
                    if(isNaN(end)) {
                        res.push(parseInt(m[1]));
                    } else {
                        res = res.concat(_.range(start,end+1));
                    }
                }
                return res;
            }, []).sort();
            console.log("GET DATE", res);
            return res;
        },
        set: function(key, values) {
            var srcDateList = _.clone(values).sort();
            let start = null;
            let end = null;
            var pushValues = function(s,e,valuesList) {
                if(s === e) {
                    valuesList.push(s.toString());
                } else {
                    valuesList.push(s.toString()+"-"+e.toString());
                }
            };
            let dateList = _.reduce(srcDateList, function(res, d, i) {
                if(start === null) {
                    start = end = d;
                }
                if(d > (end + 1)) {
                    pushValues(start, end, res);
                    start = end = d;
                } else {
                    end = d;
                }
                if(i === (srcDateList.length - 1)) {
                    pushValues(start, end, res);
                }
                return res;
          }, []);
          console.log("SET DATE",key, values, dateList);
          if(dateList.length === 0) {
              dateList = null;
          }
          this.get('filter').set('date', dateList);
          return srcDateList;
      }
    }),

    elementId: "chrono-table",

    didInsertElement: function(){
        var self = this;

        if (this.get('date') !== null){
            this.highlightQuery(this.get('date'));
        }

        var isMouseDown = false,
            isHighlighted,
            didHighlight,
            previousElement;

        Ember.$("#chrono-table li").mousedown(function (event) {
            // Prevent right click selection.
            if(event.button === 0) {

                isMouseDown = true;
                var element = parseInt(Ember.$(this).attr('id'));
                var elements = [element];
                if(event.shiftKey) {
                    while(previousElement !== element) {
                        elements.push(previousElement);
                        if(previousElement < element) {
                            previousElement = previousElement + 1;
                        } else if(previousElement > element) {
                            previousElement = previousElement - 1;
                        } else {
                            break;
                        }
                    }
                }
                var dates = self.get('date');
                var index = dates.indexOf(element);
                if((!event.shiftKey && index === -1) || (event.shiftKey && didHighlight)) {
                    dates = dates.concat(elements);
                    isHighlighted = true;
                } else {
                    elements.forEach(function(el) {
                        var id = dates.indexOf(el);
                        if((!event.shiftKey && index !== -1) || (event.shiftKey && id !== -1)) {
                            dates.splice(id, 1);
                        }
                    });
                    isHighlighted = false;
                }
                self.set('date', dates);
                didHighlight = isHighlighted;
                previousElement = element;
                // Prevent text selection.
                return false;
            }
        }).mouseover(function () {
            if (isMouseDown) {
                var element = parseInt(Ember.$(this).attr('id'));
                if(Ember.$(this).hasClass("highlighted") !== isHighlighted) {
                    var dates = self.get('date');
                    var index = dates.indexOf(element);
                    if(index === -1) {
                        dates.push(element);
                    } else {
                        dates.splice(index, 1);
                    }
                    self.set('date', dates);
                }
                previousElement = element;
            }
        }).bind("selectstart", function () {
            return false;
        });

        Ember.$(document).mouseup(function () {
            isMouseDown = false;
        });
    },

    highlightQuery: function(dates){
        console.log("highlightQuery", dates);
        if(dates === null) {
            return;
        }
        dates.map(function(date){
            Ember.$("#" + date).toggleClass("highlighted", true);
        });
    },

    actions : {

        selectDecade: function(decade) {
            var array = [];
            var next = decade + 10;
            var dates = this.get('date');
            while(decade < next) {
                array.push(decade);
                decade ++;
            }
            if(array.find(function(date){ return dates.indexOf(date) === -1; })) {
                array = array.filter(function(value) {
                    return dates.indexOf(value) === -1;
                });
                array = dates.concat(array);
            } else {
                array = dates.filter(function(value) {
                    return array.indexOf(value) === -1;
                });
            }
            this.set('date', array);
        }

    }

});
