<?php

namespace CorpusParole\Http\Controllers\Api;

use Illuminate\Http\Request;
use CorpusParole\Http\Requests;
use CorpusParole\Http\Controllers\Controller;
use CorpusParole\Services\BnfResolverInterface;
use CorpusParole\Services\BnfResolverException;

class BnfController extends Controller
{
    public function __construct(BnfResolverInterface $bnfResolver) {
        $this->bnfResolver = $bnfResolver;
    }

    public function index() {
        return print_r($this->bnfResolver, true);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id od comma separated list of ids
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $ids = array_map(function($rid) { return (strpos($rid,"ark:/12148")===0)?$rid:"ark:/12148/$rid"; },explode(",", $id));
        try {
            return response()->json(['bnfids' => $this->bnfResolver->getLabels($ids)]);
        } catch (BnfResolverException $e) {
            abort(500, $e->getMessage());
        }
    }

}
