<?php
namespace CorpusParole\Models;

use Config;
use CorpusParole\Libraries\Utils;
use CorpusParole\Libraries\CocoonUtils;
use CorpusParole\Libraries\RdfModel\RdfModelResource;
use JsonSerializable;
use Log;
use EasyRdf\Literal;
use EasyRdf\Resource;
use EasyRdf\Graph;


/**
 */
class DocumentResult extends DocumentBase {

    public function __construct($uri, $graph = null) {
        parent::__construct($uri, $graph);
    }

    private $publishers = false;
    private $duration = false;
    private $durationMs = -1;
    private $transcriptUrl = false;

    protected function clearMemoizationCache() {
        parent::clearMemoizationCache();
        $this->publishers = false;
        $this->duration = false;
        $this->durationMs = -1;
        $this->transcriptUrl = false;

    }

    public function getPublishers() {
        if($this->publishers === false) {
            try {
                $this->publishers = $this->getProvidedCHO()->getLiteral('dc11:publisher');
            } catch(\Exception $e) {
                $this->publishers = null;
            }
        }
        return $this->publishers;
    }

    public function getPublishersValue() {
        $publishers = $this->getPublishers();
        return is_null($publishers)?null:$publishers->getValue();
    }

    public function getDuration() {
        if($this->duration === false) {
            try {
                $this->duration = $this->getProvidedCHO()->getLiteral('<http://purl.org/dc/terms/extent>');
            } catch(\Exception $e) {
                $this->duration = null;
            }
        }
        return $this->duration;
    }

    public function getDurationValue() {
        if($this->durationMs === -1) {
            $this->durationMs = Utils::iso8601IntervalToMillis($this->getDuration());
        }
        return $this->durationMs;
    }

    public function getTranscriptUrl() {
        if($this->transcriptUrl === false) {
            try {
                $this->transcriptUrl = $this->getProvidedCHO()->getLiteral("<".config('corpusparole.corpus_ontology_url').'transcript'.">");
            } catch(\Exception $e) {
                $this->transcriptUrl = null;
            }
        }
        return is_null($this->transcriptUrl)?null:$this->transcriptUrl->getValue();
    }

    public function jsonSerialize() {

        $res = parent::jsonSerialize();

        if($this->graph) {
            $res = array_merge($res, [
                'publishers' => $this->getPublishersValue(),
                'duration' => $this->getDurationValue(),
                'transcript_url' => $this->getTranscriptUrl()
            ]);
        }
        return $res;
    }
}
