import Ember from 'ember';

export default Ember.Component.extend({

    sorting: [],
    sortedThemes: Ember.computed.sort('themes', 'sorting'),

    minimum: Ember.computed('themes', function() { return Math.min(...this.themes.mapBy('count')); }),

    maximum: Ember.computed('themes', function() { return Math.max(...this.themes.mapBy('count')); }),

    actions: {


        setQueryParameters: function(id) {
            this.get('setQueryParameters')(id);
        },

        sortBy: function (type) {
            this.set('sorting', type === 'popularity' ? ['count:desc'] : ['label']);
            this.get('sortedThemes');
        }

    }

});
