import Ember from 'ember';

export default Ember.Component.extend({

    player: Ember.inject.service(),
    filter: Ember.inject.service(),

    classNames: ['notice-component'],

    item: Ember.computed('model', 'player.model', function() {
        return this.get('model') || this.get('player').get('model');
    }),

    participants: Ember.computed('item.contributors', function() {
        var participants = [];
        if(this.get('item')) {
            this.get('item').get('contributors').forEach(function(contributor) {
                if(contributor.name) {
                    var participant = participants.find(participant => participant.name === contributor.name);
                    if(participant) {
                        participant['role'].push(contributor.role.split('/').pop());
                    } else {
                        participants.push({ name: contributor.name, role: [ contributor.role.split('/').pop() ] });
                    }    
                }
            });
        }
        return participants;
    }),

    subjects: Ember.computed('item.subjects', function() {
        var subjects = [];
        if(this.get('item')) {
            this.get('item').get('subjects').forEach(function(subject) {
                var object = {};
                if(typeof subject === 'object') {
                    if(subject.datatype) {
                        object['url'] = subject.datatype;
                    }
                    if(subject.value) {
                        object['name'] = subject.value;
                    }
                } else {
                    object['url'] = subject;
                }
                subjects.push(object);
            });
        }
        return subjects;
    }),

    location: Ember.computed('item.geoInfo', function() {
        var location = '';
        if(this.get('item')) {
            var meta = this.get('item').get('geoInfo').notes.find(element => element.lang);
            if(meta) {
                location = meta.value;
            }
        }
        return location;
    }),

    actions: {

        addThemeFilter: function(id) {
            this.get('filter').set('theme', id);
        },

        addLanguageFilter: function(id) {
            this.get('filter').set('language', id);
        }

    }

});
