<?php

use Mockery as m;

/**
 *
 */
class DiscourseControllerTest extends TestCase {

    const ES_QUERY = [
        'index' => 'corpus',
        'body' => [
            "size" => 0,
            "query" => [ "match_all" => [] ],
            "aggs" => [
                "discourses" => [
                    "terms" => [ "field" => "discourse_types", "order" => [ "_count" => "desc" ], "size" => 0 ]
                ]
            ]
        ]
    ];

    public function setUp() {

        parent::setup();

    }

    public function tearDown() {
        m::close();
        parent::tearDown();
    }

    public function testIndex() {

        Es::shouldReceive('search')
                ->once()
                ->with(self::ES_QUERY)
                ->andReturn(json_decode('{
  "took" : 116,
  "timed_out" : false,
  "_shards" : {
    "total" : 1,
    "successful" : 1,
    "failed" : 0
  },
  "hits" : {
    "total" : 3373,
    "max_score" : 0.0,
    "hits" : [ ]
  },
  "aggregations" : {
    "discourses" : {
      "doc_count_error_upper_bound" : 0,
      "sum_other_doc_count" : 0,
      "buckets" : [ {
        "key" : "http://ark.bnf.fr/ark:/12148/cb12083158d",
        "doc_count" : 44
      }, {
        "key" : "http://ark.bnf.fr/ark:/12148/cb119783362",
        "doc_count" : 33
      }, {
        "key" : "http://ark.bnf.fr/ark:/12148/cb13319048g",
        "doc_count" : 22
      } ]
    }
  }
}', true));

        $this->get('/api/v1/stats/discourses/')->assertTrue($this->response->isOk(), $this->response->content());

        $this->seeJsonEquals(["discourses" => [
            "http://ark.bnf.fr/ark:/12148/cb12083158d" => ["label" => "argumentation", "count" => 44],
            "http://ark.bnf.fr/ark:/12148/cb119783362" => ["label" => "bavardage", "count" => 33],
            "http://ark.bnf.fr/ark:/12148/cb13319048g" => ["label" => "chansons", "count" => 22],
        ]]);

    }

    public function testIndexQuery() {
        Es::shouldReceive('search')
                ->once()
                ->with(self::ES_QUERY)
                ->andReturn(json_decode('{
  "took" : 116,
  "timed_out" : false,
  "_shards" : {
    "total" : 1,
    "successful" : 1,
    "failed" : 0
  },
  "hits" : {
    "total" : 3373,
    "max_score" : 0.0,
    "hits" : [ ]
  },
  "aggregations" : {
    "discourses" : {
      "doc_count_error_upper_bound" : 0,
      "sum_other_doc_count" : 0,
      "buckets" : [ ]
    }
  }
}', true));
        $this->get('/api/v1/stats/discourses/')->assertTrue($this->response->isOk(), $this->response->content());
        $this->seeJsonEquals(["discourses" => [
        ]]);
    }
}
