import Ember from 'ember';

export default Ember.Component.extend({
    
    classNames: ['filter-component'],

    filter: Ember.inject.service(),

    intervals: Ember.computed('filter.date', function() {
        var intervals = [];
        this.get('filter.date').forEach(function(date) {
            var isInterval = false;
            intervals.forEach(function(interval) {
                if(interval.length && (interval.includes(date + 1) || interval.includes(date - 1))) {
                    interval.push(date);
                    isInterval = true;
                }
            });
            if (!isInterval) {
                intervals.push([date]);
            }
        });
        return intervals;
    }),

    actions: {
        removeFilter: function(key, value) {
            if(typeof this.get('filter').get(key) === 'object') {
                var array = value.toArray();
                value = this.get('filter').get(key).toArray();
                array.forEach(function(element) {
                    value.splice(value.indexOf(element), 1);
                });
            }
            this.get('filter').set(key, value);
        }
    }

});
