<?php
namespace CorpusParole\Models;

use CorpusParole\Libraries\RdfModel\RdfModelResource;
use CorpusParole\Libraries\Utils;

use JsonSerializable;
use Log;


/**
 */
class MediaResource extends WebResource  {

    private $master = false;
    private $extent = -1;
    private $extentMs = -1;

    public function __construct(...$args) {
        //print($graph->dump('html'));
        parent::__construct(...$args);
        list(,,$master) = $args;
        $this->master = $master;
    }

    public function isMaster() {
        return $this->master;
    }

    protected function doClearMemoizationCache() {
        $this->extent = -1;
        $this->extentMs = -1;
    }

    public function getExtent() {
        if($this->extent === -1) {
            $extent = $this->getLiteral("<http://purl.org/dc/terms/extent>");
            $this->extent = is_null($extent)?null:$extent->getValue();
        }

        return $this->extent;
    }

    public function getExtentMs() {
        if($this->extentMs === -1 ) {
            $this->extentMs = Utils::iso8601IntervalToMillis($this->getExtent());
        }
        return $this->extentMs;
    }


    protected function jsonSerializeExtra() {
        return [
            'extent' => $this->getExtent(),
            'extent_ms' => $this->getExtentMs(),
            'master' => $this->isMaster()
        ];
    }

}