<?php
namespace CorpusParole\Libraries\Transcript;

interface TranscriptConverterInterface {

    /**
     * parse the source document.
     */
    function parseSource();

    /**
     * Return the id of the media used as reference.
     */
    function getMediaRefId();

    /**
     * return the source title, can return null.
     */
    function getSourceTitle();

    /**
     * build the various document parts
     */
    function buildMedias();
    function buildResources();
    function buildLists();
    function buildAnnotationTypes();
    function buildAnnotations();

    /**
     * Convert xml to json.
     * return an PHP array ready for serialization
     */
    function convertToJson();


}