<?php

namespace CorpusParole\Http\Controllers\Api;

use Illuminate\Http\Request;

use CorpusParole\Http\Requests;
use CorpusParole\Http\Controllers\Controller;
use Es;

class GeoStatsController extends Controller
{
    /**
     * Display the specified resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $query = [
            'index' => env('ELASTICSEARCH_INDEX'),
            'body' => [
                "size" => 0,
                "aggs" => [
                    "geos" => [
                        "terms" => [
                            "size" => 0,
                            "field" => "geonames_hierarchy"
                        ]
                    ]
                ]
            ]
        ];
        $esRes = Es::search($query);

        $geosats = [];

        foreach($esRes['aggregations']['geos']['buckets'] as $bucket) {
            $geosats[(string)($bucket['key'])] = $bucket['doc_count'];
        }

        return response()->json(['geostats' => $geosats ]);
    }
}
