class sysconfig::sesame (
) inherits sysconfig::params {

    define create_lexvo_repository($unless = undef) {

        file { "lexvo_tmp_dir":
            path => "/tmp/lexvo",
            ensure => directory,
        }->
        file { "lexvo_data_archive":
            path => "/tmp/lexvo/lexvo.rdf.bz2",
            ensure => present,
            source => "puppet:///modules/sysconfig/sesame/lexvo_2013-02-09_cleaned.rdf.bz2",
        }->
        exec { "lexvo_data_extract":
            command => "/usr/bin/bunzip2 /tmp/lexvo/lexvo.rdf.bz2",
            unless => $unless,
            creates => "/tmp/lexvo/lexvo.rdf"
        }->
        file { "lexvo_commands":
            path => "/tmp/lexvo/console_commands.txt",
            ensure => present,
            source => "puppet:///modules/sysconfig/sesame/console_commands.txt",
        }->
        exec { "lexvo_console":
            command => "/opt/sesame/bin/console.sh < /tmp/lexvo/console_commands.txt",
            cwd => "/opt/sesame/bin",
            creates => "/opt/sesame/.lexvo_loaded",
            unless => $unless
        }->
        exec { "lexvo_data_archive_delete":
            command => "/usr/bin/rm -fr /tmp/lexvo"
        }->
        file { "/opt/sesame/.lexvo_loaded":
            ensure => present,
            content => "",
        }

        #->
        # File <| title == "lexvo_tmp_dir" |> {
        #     path => "/tmp/lexvo",
        #     ensure => absent,
        # }
    }

    file { "/opt/sesame":
        ensure => directory,
    }->
    archive { 'openrdf-sesame-4':
        ensure => present,
        url => "http://sourceforge.net/projects/sesame/files/Sesame%204/4.0.1/openrdf-sesame-4.0.1-sdk.tar.gz/download",
        checksum => false,
        follow_redirects => true,
        strip_components => 1,
        target => "/opt/sesame",
        src_target => '/tmp',
        timeout => 500,
    }->
    file { [ "/var/lib/sesame",
             "/var/lib/sesame/data" ]:
        ensure => directory,
        owner => "tomcat",
        group => "tomcat",
        require => Package['tomcat']
    }->
    augeas { "etc-sysconfig/tomcat":
        context => "/files/etc/sysconfig/tomcat",
        changes => [
            "set JAVA_OPTS '\"-Dinfo.aduna.platform.appdata.basedir=/var/lib/sesame/data -Xms512m -Xmx512m\"'"
        ],
        notify => Service['tomcat']
    }->
    exec { "copy-sesame-tomcat":
         command => "/usr/bin/cp /opt/sesame/war/*.war /var/lib/tomcat/webapps",
         notify => Service['tomcat']
    }->
    create_lexvo_repository { "create-lexvo-repository":
        unless => '/usr/bin/curl -s -f -I http://localhost:8080/openrdf-sesame/repositories/lexvo/statements'
    }


#
#download archive

#put war at the right place

#create the repository if not exists

}
