import Ember from 'ember';
import ClickOutsideMixin from 'bo-client/mixins/click-outside-mixin';

export default Ember.Mixin.create(ClickOutsideMixin, {
  isEditing: false,
  // override from ClickOutsideMixin
  onOutsideClickEnabled: Ember.computed.bool('isEditing'),

  onOutsideClick() {
    this.set('isEditing', false);
  },
  click() {
    var _this = this;
    setTimeout(() => {
      _this.set('isEditing', true);
    }, 200);
  },
  keyDown(event) {
    if(event.which === this.get('constants').KEY_CODES.ESCAPE) {
      this.set('isEditing', false);
    }
  },

});
