<?php

namespace CorpusParole\Http\Controllers\Api;

use Illuminate\Http\Request;

use CorpusParole\Http\Requests;
use CorpusParole\Http\Controllers\Controller;
use CorpusParole\Repositories\DocumentRepository;

class DocumentController extends Controller
{
    /**
     * Create a new controller instance.
     */
    public function __construct(DocumentRepository $documentRepo) {
        $this->documentRepository = $documentRepo;
    }

    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index()
    {
        $paginator = $this->documentRepository->paginateAll();
        $res = [];
        foreach ($paginator->toArray() as $key => $value) {
            $res[($key === 'data')?'documents':$key] = $value;
        }
        return response()->json($res);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  Request  $request
     * @return Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return Response
     */
    public function show($id)
    {
        $doc = $this->documentRepository->get($id);
        if(is_null($doc)) {
            abort(404);
        }
        return response()->json(["document" => $doc]);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  Request  $request
     * @param  int  $id
     * @return Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return Response
     */
    public function destroy($id)
    {
        //
    }
}
