<?php

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It's a breeze. Simply tell Laravel the URIs it should respond to
| and give it the controller to call when that URI is requested.
|
*/

Route::get('/', 'WelcomeController@index');

Route::get('home', 'HomeController@index');

Route::group(['middleware' => ['web']], function () {

    //Route::get('bo/docs/docDetailClient', 'Bo\DocumentListController@showClient');
    Route::pattern('docs', ".*");
    Route::get('bo/docs/client/{docs}', 'Bo\DocumentListController@getClient')
        ->name('bo.docs.client')
        ->where('docs', '.+');
    Route::resource('bo/docs', 'Bo\DocumentListController');


    Route::controllers([
    //    'auth' => 'Auth\AuthController',
        'password' => 'Auth\PasswordController',
    ]);
});

/*
|--------------------------------------------------------------------------
| Api Route
|--------------------------------------------------------------------------
|
|
*/

Route::group(['prefix' => 'api/v1', 'middleware' => 'cors'] , function() {
    Route::pattern('documents', ".*");
    Route::resource('documents', 'Api\DocumentController',
                    ['only' => ['index', 'show', 'update']]);
    Route::resource('viaf', 'Api\ViafController',
                    ['only' => ['show']]);
    Route::resource('lexvo', 'Api\LexvoController',
                    ['only' => ['show']]);
    Route::resource('bnf', 'Api\BnfController',
                    ['only' => ['index','show']]);
    Route::resource('languages', 'Api\LanguageController',
                    ['only' => ['index']]);
    Route::resource('themes', 'Api\ThemeController',
                    ['only' => ['index']]);

});

/*
|--------------------------------------------------------------------------
| Proxy Route
|--------------------------------------------------------------------------
|
|
*/
Route::group(['prefix' => 'proxy', 'middleware' => 'cors'] , function() {
    Route::get('bnf', 'Proxy\BnfController@proxyAutoCompletion');
    Route::get('bnf-sparql', 'Proxy\BnfController@proxySparql');
});
