<?php

use CorpusParole\Libraries\Mergers\CocoonSoundRdfMerger;
use CorpusParole\Libraries\Mergers\CocoonTextRdfMerger;
use CorpusParole\Libraries\CocoonUtils;

use EasyRdf\Graph;
use EasyRdf\Resource;
use EasyRdf\Literal;

use Illuminate\Foundation\Testing\WithoutMiddleware;
use Illuminate\Foundation\Testing\DatabaseMigrations;
use Illuminate\Foundation\Testing\DatabaseTransactions;

class CocoonTextRdfMergerTest extends TestCase
{

    const TEST_INPUT_DOCS = [
        'SOUND' => <<<EOT
        @prefix ore: <http://www.openarchives.org/ore/terms/> .
        @prefix edm: <http://www.europeana.eu/schemas/edm/> .
        @prefix dc11: <http://purl.org/dc/elements/1.1/> .
        @prefix olac: <http://www.language-archives.org/OLAC/1.1/> .
        @prefix dc: <http://purl.org/dc/terms/> .
        @prefix geo: <http://www.w3.org/2003/01/geo/wgs84_pos#> .
        @prefix xsd: <http://www.w3.org/2001/XMLSchema#> .
        @prefix skos: <http://www.w3.org/2004/02/skos/core#> .
        @prefix owl: <http://www.w3.org/2002/07/owl#> .

        <http://purl.org/poi/corpusdelaparole.huma-num.fr/crdo-UVE_MOCIKA_SOUND>
          a ore:Aggregation ;
          edm:aggregatedCHO <http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-UVE_MOCIKA_SOUND> ;
          edm:provider "Corpus de la Parole"@fr ;
          edm:dataProvider "Laboratoire de langues et civilisations à tradition orale" ;
          edm:isShownAt <http://cocoon.huma-num.fr/exist/crdo/meta/crdo-UVE_MOCIKA_SOUND> ;
          edm:isShownBy <http://cocoon.huma-num.fr/data/archi/masters/144187.wav> ;
          edm:rights <http://creativecommons.org/licenses/by-nc-nd/4.0/> ;
          edm:hasView <http://cocoon.huma-num.fr/data/archi/144187_MOCIKA_22km.wav>, <http://cocoon.huma-num.fr/data/archi/mp3/144187_MOCIKA_44k.mp3> .

        <http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-UVE_MOCIKA_SOUND>
          a edm:ProvidedCHO ;
          dc:identifier "crdo-UVE_MOCIKA_SOUND" ;
          dc11:description "Voilà pourquoi le bernard-l'hermite, aujourd'hui, se cache dans les coquilles vides qu'il trouve, alors que le crabe de cocotier n'a pas honte de se promener tout nu."@fr ;
          dc11:language <http://lexvo.org/id/iso639-3/uve> ;
          dc11:publisher "Laboratoire de langues et civilisations à tradition orale" ;
          dc11:rights "Copyright (c) Moyse-Faurie, Claire" ;
          dc11:type <http://purl.org/dc/dcmitype/Sound>, "primary_text"^^olac:linguistic-type, "narrative"^^olac:discourse-type, <http://ark.bnf.fr/ark:/12148/cb11937212q> ;
          dc:license <http://creativecommons.org/licenses/by-nc-nd/2.5/> ;
          dc11:subject <http://ark.bnf.fr/ark:/12148/cb11958119h>, <http://lexvo.org/id/iso639-3/uve>, <http://ark.bnf.fr/ark:/12148/cb11953067w> ;
          dc11:title "The two hermit crabs and the coconut crab"@en ;
          dc:accessRights "Freely available for non-commercial use" ;
          dc:extent "PT2M35S" ;
          edm:isGatheredInto <http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-COLLECTION_LANGUESDEFRANCE>, <http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-COLLECTION_LACITO> ;
          olac:depositor <http://viaf.org/viaf/56614135> ;
          dc11:contributor <http://viaf.org/viaf/56614135>, "Idakote, Félicien" ;
          olac:researcher <http://viaf.org/viaf/56614135> ;
          olac:speaker "Idakote, Félicien" ;
          dc:available "2010-10-23"^^dc:W3CDTF ;
          dc:created "1997-08-29"^^dc:W3CDTF ;
          dc:issued "2010-10-23T00:08:27+02:00"^^dc:W3CDTF ;
          dc:modified "2012-03-25"^^dc:W3CDTF ;
          dc:spatial [
            a edm:Place ;
            geo:lat "-20.46667"^^xsd:float ;
            geo:long "166.65"^^xsd:float ;
            skos:note "NC"^^dc:ISO3166, "New Caledonia, Ohnyat (Ouvéa)" ;
            owl:sameAs <http://sws.geonames.org/2139490/>
          ] .

        <http://cocoon.huma-num.fr/data/archi/masters/144187.wav>
          a edm:WebResources ;
          dc:extent "PT2M35S" ;
          dc11:format "audio/x-wav"^^dc:IMT ;
          dc:created "1997-08-29"^^dc:W3CDTF ;
          dc:issued "2010-10-23T00:08:27+02:00"^^dc:W3CDTF .

        <http://cocoon.huma-num.fr/data/archi/144187_MOCIKA_22km.wav>
          a edm:WebResources ;
          dc:extent "PT2M35S" ;
          dc11:format "audio/x-wav"^^dc:IMT ;
          edm:isDerivativeOf <http://cocoon.huma-num.fr/data/archi/masters/144187.wav> ;
          dc:created "1997-08-29"^^dc:W3CDTF ;
          dc:issued "2010-10-23T00:08:27+02:00"^^dc:W3CDTF .

        <http://cocoon.huma-num.fr/data/archi/mp3/144187_MOCIKA_44k.mp3>
          a edm:WebResources ;
          dc:extent "PT2M35S" ;
          dc11:format "audio/mpeg"^^dc:IMT ;
          edm:isDerivativeOf <http://cocoon.huma-num.fr/data/archi/masters/144187.wav> ;
          dc:created "1997-08-29"^^dc:W3CDTF ;
          dc:issued "2010-10-23T00:08:27+02:00"^^dc:W3CDTF .
EOT
        ,
        'SOUND_NO_MOD' => <<<EOT
        @prefix ore: <http://www.openarchives.org/ore/terms/> .
        @prefix edm: <http://www.europeana.eu/schemas/edm/> .
        @prefix dc11: <http://purl.org/dc/elements/1.1/> .
        @prefix olac: <http://www.language-archives.org/OLAC/1.1/> .
        @prefix dc: <http://purl.org/dc/terms/> .
        @prefix geo: <http://www.w3.org/2003/01/geo/wgs84_pos#> .
        @prefix xsd: <http://www.w3.org/2001/XMLSchema#> .
        @prefix skos: <http://www.w3.org/2004/02/skos/core#> .
        @prefix owl: <http://www.w3.org/2002/07/owl#> .

        <http://purl.org/poi/corpusdelaparole.huma-num.fr/crdo-UVE_MOCIKA_SOUND>
          a ore:Aggregation ;
          edm:aggregatedCHO <http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-UVE_MOCIKA_SOUND> ;
          edm:provider "Corpus de la Parole"@fr ;
          edm:dataProvider "Laboratoire de langues et civilisations à tradition orale" ;
          edm:isShownAt <http://cocoon.huma-num.fr/exist/crdo/meta/crdo-UVE_MOCIKA_SOUND> ;
          edm:isShownBy <http://cocoon.huma-num.fr/data/archi/masters/144187.wav> ;
          edm:rights <http://creativecommons.org/licenses/by-nc-nd/4.0/> ;
          edm:hasView <http://cocoon.huma-num.fr/data/archi/144187_MOCIKA_22km.wav>, <http://cocoon.huma-num.fr/data/archi/mp3/144187_MOCIKA_44k.mp3> .

        <http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-UVE_MOCIKA_SOUND>
          a edm:ProvidedCHO ;
          dc:identifier "crdo-UVE_MOCIKA_SOUND" ;
          dc11:description "Voilà pourquoi le bernard-l'hermite, aujourd'hui, se cache dans les coquilles vides qu'il trouve, alors que le crabe de cocotier n'a pas honte de se promener tout nu."@fr ;
          dc11:language <http://lexvo.org/id/iso639-3/uve> ;
          dc11:publisher "Laboratoire de langues et civilisations à tradition orale" ;
          dc11:rights "Copyright (c) Moyse-Faurie, Claire" ;
          dc11:type <http://purl.org/dc/dcmitype/Sound>, "primary_text"^^olac:linguistic-type, "narrative"^^olac:discourse-type, <http://ark.bnf.fr/ark:/12148/cb11937212q> ;
          dc:license <http://creativecommons.org/licenses/by-nc-nd/2.5/> ;
          dc11:subject <http://ark.bnf.fr/ark:/12148/cb11958119h>, <http://lexvo.org/id/iso639-3/uve>, <http://ark.bnf.fr/ark:/12148/cb11953067w> ;
          dc11:title "The two hermit crabs and the coconut crab"@en ;
          dc:accessRights "Freely available for non-commercial use" ;
          dc:extent "PT2M35S" ;
          edm:isGatheredInto <http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-COLLECTION_LANGUESDEFRANCE>, <http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-COLLECTION_LACITO> ;
          olac:depositor <http://viaf.org/viaf/56614135> ;
          dc11:contributor <http://viaf.org/viaf/56614135>, "Idakote, Félicien" ;
          olac:researcher <http://viaf.org/viaf/56614135> ;
          olac:speaker "Idakote, Félicien" ;
          dc:available "2010-10-23"^^dc:W3CDTF ;
          dc:created "1997-08-29"^^dc:W3CDTF ;
          dc:issued "2010-10-23T00:08:27+02:00"^^dc:W3CDTF ;
          dc:spatial [
            a edm:Place ;
            geo:lat "-20.46667"^^xsd:float ;
            geo:long "166.65"^^xsd:float ;
            skos:note "NC"^^dc:ISO3166, "New Caledonia, Ohnyat (Ouvéa)" ;
            owl:sameAs <http://sws.geonames.org/2139490/>
          ] .

        <http://cocoon.huma-num.fr/data/archi/masters/144187.wav>
          a edm:WebResources ;
          dc:extent "PT2M35S" ;
          dc11:format "audio/x-wav"^^dc:IMT ;
          dc:created "1997-08-29"^^dc:W3CDTF ;
          dc:issued "2010-10-23T00:08:27+02:00"^^dc:W3CDTF .

        <http://cocoon.huma-num.fr/data/archi/144187_MOCIKA_22km.wav>
          a edm:WebResources ;
          dc:extent "PT2M35S" ;
          dc11:format "audio/x-wav"^^dc:IMT ;
          edm:isDerivativeOf <http://cocoon.huma-num.fr/data/archi/masters/144187.wav> ;
          dc:created "1997-08-29"^^dc:W3CDTF ;
          dc:issued "2010-10-23T00:08:27+02:00"^^dc:W3CDTF .

        <http://cocoon.huma-num.fr/data/archi/mp3/144187_MOCIKA_44k.mp3>
          a edm:WebResources ;
          dc:extent "PT2M35S" ;
          dc11:format "audio/mpeg"^^dc:IMT ;
          edm:isDerivativeOf <http://cocoon.huma-num.fr/data/archi/masters/144187.wav> ;
          dc:created "1997-08-29"^^dc:W3CDTF ;
          dc:issued "2010-10-23T00:08:27+02:00"^^dc:W3CDTF .
EOT
        ,
        'TEXT' => <<<EOT
        @prefix ore: <http://www.openarchives.org/ore/terms/> .
        @prefix edm: <http://www.europeana.eu/schemas/edm/> .
        @prefix dc11: <http://purl.org/dc/elements/1.1/> .
        @prefix olac: <http://www.language-archives.org/OLAC/1.1/> .
        @prefix dc: <http://purl.org/dc/terms/> .
        @prefix skos: <http://www.w3.org/2004/02/skos/core#> .

        <http://purl.org/poi/corpusdelaparole.huma-num.fr/crdo-UVE_MOCIKA_SOUND>
          a ore:Aggregation ;
          edm:aggregatedCHO <http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-UVE_MOCIKA_SOUND> ;
          edm:provider "Corpus de la Parole"@fr ;
          edm:dataProvider <http://viaf.org/viaf/154919513> ;
          edm:isShownAt <http://cocoon.huma-num.fr/exist/crdo/meta/crdo-UVE_MOCIKA_SOUND> ;
          edm:isShownBy <http://cocoon.huma-num.fr/exist/crdo/moyse-faurie/uve/crdo-UVE_MOCIKA.xml> ;
          edm:rights <http://creativecommons.org/licenses/by-nc-sa/4.0/> ;
          edm:hasView <http://cocoon.huma-num.fr/exist/crdo/moyse-faurie/uve/crdo-UVE_MOCIKA.xml>, <http://cocoon.huma-num.fr/exist/crdo/moyse-faurie/uve/crdo-UVE_MOCIKA.xhtml> .

        <http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-UVE_MOCIKA_SOUND>
          a edm:ProvidedCHO ;
          dc:identifier "crdo-UVE_MOCIKA_SOUND" ;
          dc11:description "Voilà pourquoi le bernard-l'hermite, aujourd'hui, se cache dans les coquilles vides qu'il trouve, alors que le crabe de cocotier n'a pas honte de se promener tout nu."@fr ;
          dc11:language <http://lexvo.org/id/iso639-3/uve> ;
          dc11:publisher <http://viaf.org/viaf/154919513> ;
          dc11:rights "Copyright (c) Moyse-Faurie, Claire" ;
          dc11:type "primary_text"^^olac:linguistic-type, <http://purl.org/dc/dcmitype/Text>, "narrative"^^olac:discourse-type ;
          dc:license <http://creativecommons.org/licenses/by-nc-sa/2.5/> ;
          dc11:subject <http://lexvo.org/id/iso639-3/uve> ;
          dc11:title "The two hermit crabs and the coconut crab"@en ;
          dc:accessRights "Freely available for non-commercial use" ;
          edm:isGatheredInto <http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-COLLECTION_LANGUESDEFRANCE>, <http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-COLLECTION_LACITO> ;
          dc:alternative "Les deux bernard-l'hermite et le crabe de cocotier"@fr ;
          olac:depositor <http://viaf.org/viaf/56614135> ;
          dc11:contributor <http://viaf.org/viaf/56614135>, "Moyse-Faurie, Claire", "Idakote, Félicien" ;
          olac:researcher "Moyse-Faurie, Claire" ;
          olac:speaker "Idakote, Félicien" ;
          dc:available "2011-02-05"^^dc:W3CDTF ;
          dc:issued "2011-02-05T23:22:23+01:00"^^dc:W3CDTF ;
          dc:modified "2002-02-20"^^dc:W3CDTF ;
          dc:spatial [
            a edm:Place ;
            skos:note "NC"^^dc:ISO3166, "New Caledonia, Ohnyat (Ouvéa)"
          ] .

        <http://cocoon.huma-num.fr/exist/crdo/moyse-faurie/uve/crdo-UVE_MOCIKA.xml>
          a edm:WebResources ;
          dc11:format "application/xml"^^dc:IMT ;
          dc:issued "2011-02-05T23:22:23+01:00"^^dc:W3CDTF .

        <http://cocoon.huma-num.fr/exist/crdo/moyse-faurie/uve/crdo-UVE_MOCIKA.xhtml>
          a edm:WebResources ;
          dc11:format "application/xhtml+xml"^^dc:IMT ;
          dc:issued "2011-02-05T23:22:23+01:00"^^dc:W3CDTF .
EOT
    ];


    private $inputGraphes = [];
    private $resGraph = [];

    function __construct(string $name = null) {
        parent::__construct($name);
    }

    public function setUp() {
        parent::setUp();

        foreach(CocoonTextRdfMergerTest::TEST_INPUT_DOCS as $key => $inputDoc) {
            $this->inputGraphes[$key] = new Graph("http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-CFPP2000_35_SOUND", $inputDoc);
        }

        $merger = new CocoonTextRdfMerger();
        $this->resGraph['SOUND_TEXT'] = $merger->mergeGraph($this->inputGraphes['SOUND'], $this->inputGraphes['TEXT']);
        $merger = new CocoonSoundRdfMerger();
        $this->resGraph['TEXT_SOUND'] = $merger->mergeGraph($this->inputGraphes['TEXT'], $this->inputGraphes['SOUND']);
        $merger = new CocoonTextRdfMerger();
        $this->resGraph['SOUND_NO_MOD_TEXT'] = $merger->mergeGraph($this->inputGraphes['SOUND_NO_MOD'], $this->inputGraphes['TEXT']);
        $merger = new CocoonSoundRdfMerger();
        $this->resGraph['TEXT_SOUND_NO_MOD'] = $merger->mergeGraph($this->inputGraphes['TEXT'], $this->inputGraphes['SOUND_NO_MOD']);
    }

    public function tearDown() {
        parent::tearDown();
    }

    /**
     * Just test that the construct and setup are ok
     *
     * @return void
     */
    public function testInit()
    {
        $this->assertTrue(true);
        //echo $this->resGraph->serialise('turtle');
    }

    /**
     * Test merge modified merge TEXT into SOUND
     *
     * @return void
     */
    public function testModifiedSoundText() {

        $resGraph = $this->resGraph["SOUND_TEXT"];

        $providedCHO = $resGraph->get('edm:ProvidedCHO', '^rdf:type');
        $baseNode = $this->inputGraphes['SOUND']->get('edm:ProvidedCHO', '^rdf:type');
        $this->assertNotNull($providedCHO);
        $this->assertNotNull($baseNode);

        $outputValuesStr = [];
        foreach($providedCHO->all($resGraph->resource("http://purl.org/dc/terms/modified")) as $outputValue) {
            array_push($outputValuesStr, strval($outputValue));
        }
        $this->assertNotEmpty($outputValuesStr, "we must found some values to test http://purl.org/dc/terms/modified");
        foreach ($baseNode->all($this->inputGraphes['SOUND']->resource("http://purl.org/dc/terms/modified")) as $value) {
            $this->assertContains(strval($value), $outputValuesStr, "http://purl.org/dc/terms/modified not found in output graph");
        }

    }

    /**
     * Test one to one mapping
     *
     * @return void
     */
    public function testModifiedTextSound() {

        $resGraph = $this->resGraph["TEXT_SOUND"];

        $providedCHO = $resGraph->get('edm:ProvidedCHO', '^rdf:type');
        $baseNode = $this->inputGraphes['SOUND']->get('edm:ProvidedCHO', '^rdf:type');
        $this->assertNotNull($providedCHO);
        $this->assertNotNull($baseNode);

        $outputValuesStr = [];
        foreach($providedCHO->all($resGraph->resource("http://purl.org/dc/terms/modified")) as $outputValue) {
            array_push($outputValuesStr, strval($outputValue));
        }
        $this->assertNotEmpty($outputValuesStr, "we must found some values to test http://purl.org/dc/terms/modified");
        foreach ($baseNode->all($this->inputGraphes['SOUND']->resource("http://purl.org/dc/terms/modified")) as $value) {
            $this->assertContains(strval($value), $outputValuesStr, "http://purl.org/dc/terms/modified not found in output graph");
        }

    }

    /**
     * Test one to one mapping
     *
     * @return void
     */
    public function testSoundNoModifiedText() {

        $resGraph = $this->resGraph["SOUND_NO_MOD_TEXT"];

        $providedCHO = $resGraph->get('edm:ProvidedCHO', '^rdf:type');
        $baseNode = $this->inputGraphes['TEXT']->get('edm:ProvidedCHO', '^rdf:type');
        $this->assertNotNull($providedCHO);
        $this->assertNotNull($baseNode);

        $outputValuesStr = [];
        foreach($providedCHO->all($resGraph->resource("http://purl.org/dc/terms/modified")) as $outputValue) {
            array_push($outputValuesStr, strval($outputValue));
        }
        $this->assertNotEmpty($outputValuesStr, "we must found some values to test http://purl.org/dc/terms/modified");
        // must contain the TEXT modified value (since SOUND has none)
        foreach ($baseNode->all($this->inputGraphes['TEXT']->resource("http://purl.org/dc/terms/modified")) as $value) {
            $this->assertContains(strval($value), $outputValuesStr, "http://purl.org/dc/terms/modified not found in output graph");
        }

    }


    /**
     * Test one to one mapping
     *
     * @return void
     */
    public function testTextSoundNoModified() {

        $resGraph = $this->resGraph["TEXT_SOUND_NO_MOD"];

        $providedCHO = $resGraph->get('edm:ProvidedCHO', '^rdf:type');
        $baseNode = $this->inputGraphes['TEXT']->get('edm:ProvidedCHO', '^rdf:type');
        $this->assertNotNull($providedCHO);
        $this->assertNotNull($baseNode);

        $outputValuesStr = [];
        foreach($providedCHO->all($resGraph->resource("http://purl.org/dc/terms/modified")) as $outputValue) {
            array_push($outputValuesStr, strval($outputValue));
        }
        $this->assertNotEmpty($outputValuesStr, "we must found some values to test http://purl.org/dc/terms/modified");
        // must contain the TEXT modified value (since SOUND has none)
        foreach ($baseNode->all($this->inputGraphes['TEXT']->resource("http://purl.org/dc/terms/modified")) as $value) {
            $this->assertContains(strval($value), $outputValuesStr, "http://purl.org/dc/terms/modified not found in output graph");
        }

    }


}
