class sysconfig::memcached (
    $memcached_max_memory     = hiera('sysconfig::params::memcached_max_memory', $sysconfig::params::memcached_max_memory),
) inherits sysconfig::params {

    notify {'memcached': name => "\$memcached_max_memory : ${memcached_max_memory}", withpath => true }

    package { 'memcached':
        ensure => present,
    }->
    service { 'memcached':
        ensure => running,
        enable => true
    }

    $max_memory = memcached_max_memory($memcached_max_memory)
    file { "/etc/systemd/system/memcached.service.d":
        ensure => 'directory'
    }->
    file { "/etc/systemd/system/memcached.service.d/memcached_socket_dir.conf":
        mode   => 755,
        source => "puppet:///modules/sysconfig/memcached_socket_dir.conf",
        require => Package['memcached']
    }->
    exec { 'systemctl-daemon-reload':
      command => '/usr/bin/systemctl daemon-reload',
    }->
    augeas { 'etc-sysconfig/memcached':
        context => "/files/etc/sysconfig/memcached",
        changes => [
            "set PORT '\"0\"'",
            "set CACHESIZE '\"$max_memory\"'",
            "set OPTIONS '\"-s /var/run/memcached/memcached.sock -a 0766\"'"
        ],
        notify => Service['memcached'],
        require => Package['memcached']
    }

}
