<?php
namespace CorpusParole\Libraries\Mergers;


// @prefix ore: <http://www.openarchives.org/ore/terms/> .
// @prefix edm: <http://www.europeana.eu/schemas/edm/> .
// @prefix dc: <http://purl.org/dc/terms/> .
// @prefix dc11: <http://purl.org/dc/elements/1.1/> .
// @prefix olac: <http://www.language-archives.org/OLAC/1.1/> .
// @prefix geo: <http://www.w3.org/2003/01/geo/wgs84_pos#> .
// @prefix xsd: <http://www.w3.org/2001/XMLSchema#> .
// @prefix skos: <http://www.w3.org/2004/02/skos/core#> .
// @prefix owl: <http://www.w3.org/2002/07/owl#> .
//
// <http://corpusdelaparole.huma-num.fr/corpus/res/crdo-ESLO1_ENT_019>
//   a ore:Aggregation ;
//   edm:aggregatedCHO <http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-ESLO1_ENT_019> ;
//   edm:provider "Corpus de la Parole"@fr ;
//   edm:dataProvider <http://viaf.org/viaf/181558906> ;
//   edm:isShownAt <http://corpusdelaparole.huma-num.fr/corpus-app#/detail/crdo-ESLO1_ENT_019> ;
//   edm:isShownBy <http://cocoon.huma-num.fr/data/eslo/masters/ESLO1_ENT_019.wav> ;
//   edm:rights <http://creativecommons.org/licenses/by-nc-sa/4.0/> ;
//   edm:hasView <http://cocoon.huma-num.fr/data/eslo/ESLO1_ENT_019_22km.wav>, <http://cocoon.huma-num.fr/data/eslo/ESLO1_ENT_019.mp3> .
//
// <http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-ESLO1_ENT_019>
//   a edm:ProvidedCHO ;
//   dc:tableOfContents "01 née; famille a toujours habité Orléans03 oui, on y a des amis, relations04 oui, certainementT1 centralisait comptabilité dans une industrieT2 RR passer des écritures, caisse; horaires avant et après loi de 1936T3 aimait travail, rien ne lui déplaisaitT4 n'a jamais pensé à çaT5 actuellement on est forcée quelquefois - assurance sociale - retraite appréciable; autre chose avec enfantL1 concerts, théâtre, réunions, etc...:préfère s'occuperL2 messe, puis a passé la journée avec une amieL3 (quand elle travaillait) au bord de la mer ou voyages organisésE1 n'en sait rienE2 lui semble que ça aide le françaisE3 peut-être chimie, physiqueE4 intelligence, travail, familleE5 dépend de leurs capacitésE6 non : dépend de la vie de l'enfant plus tardP1 oui, à part loyers chersP4 ne comprend pas motifs des étudiants; très calme à OrléansP9 moins qu'avant 1940P10 RR bourgeois = gros rentiers, femmes d'officierss, gros industriels; chaque groupe se recevait mutuellement, formait un clanQ. Orléans une ville renfermée? oui : orléanais assez distant, peut-être moins maintenantP6 il faut avoir la moitié des votesP7 des candidats se retirentP8 droite gaulliste, réservée; gauche avancéeP5 pas grand-chose - attachés à leurs partisP11 oui, maintenant, par l'éducation; famille moins importanteP12 à diminuer : les gens travaillent beaucoup plus et l'argent a changé de mainsOmelette (je casse mes oeufs...)Questionnaire sociolinguistique"@fr ;
//   dc11:description "Extrait du corpus d'Orléans, réalisé dans le cadre de l'Enquête SocioLinguistique à Orléans à la fin des années 1960."@fr ;
//   dc11:language <http://lexvo.org/id/iso639-3/fra> ;
//   dc11:publisher <http://viaf.org/viaf/181558906> ;
//   dc11:rights "Copyright (c) 2012 Université d'Orléans/LLL" ;
//   dc11:type <http://purl.org/dc/dcmitype/Sound>, "primary_text"^^olac:linguistic-type, "dialogue"^^olac:discourse-type ;
//   dc:license <http://creativecommons.org/licenses/by-nc-sa/3.0/> ;
//   dc11:subject <http://lexvo.org/id/iso639-3/fra>, "text_and_corpus_linguistics"^^olac:linguistic-field, <http://ark.bnf.fr/ark:/12148/cb135052099>, <http://ark.bnf.fr/ark:/12148/cb11943508j>, <http://ark.bnf.fr/ark:/12148/cb11934124q>, <http://ark.bnf.fr/ark:/12148/cb11931498c>, <http://ark.bnf.fr/ark:/12148/cb11935508t>, <http://ark.bnf.fr/ark:/12148/cb11934132b>, <http://ark.bnf.fr/ark:/12148/cb11939893p>, <http://ark.bnf.fr/ark:/12148/cb11933091b> ;
//   dc11:title "ESLO1: entretien 019"@fr ;
//   dc:accessRights "Freely available for non-commercial use" ;
//   dc:extent "PT0H47M16S" ;
//   dc:isPartOf <http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-COLLECTION_LANGUESDEFRANCE>, <http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-COLLECTION_ESLO1> ;
//   dc11:source <http://archivesetmanuscrits.bnf.fr/ead.html?id=FRBNFEAD000095934&c=FRBNFEAD000095934_a19844296> ;
//   dc:medium "1 bande magnétique audio"@fr ;
//   dc:alternative "ESLO1: entretien 019 alt"@fr ;
//   dc:bibliographicCitation "A.-M. VURPAS (1988), Autrefois dans les monts du Beaujolais, Action graphique." ;
//   dc11:identifier "Cote producteur: 001_3"@fr ;
//   dc:references <http://panini.u-paris10.fr> ;
//   dc11:coverage "Quartier concerné : Montreuil"@fr ;
//   dc11:relation <http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-ESLO1_ENTCONT_233> ;
//   dc11:creator "Blanc, Michel", "Biggs, Patricia" ;
//   olac:depositor <http://viaf.org/viaf/181558906> ;
//   dc11:contributor <http://viaf.org/viaf/181558906>, <http://viaf.org/viaf/39685504>, <http://viaf.org/viaf/200058210>, "Kay, Jack", "JK", "UG393" ;
//   olac:editor <http://viaf.org/viaf/39685504>, <http://viaf.org/viaf/200058210> ;
//   olac:researcher "Kay, Jack" ;
//   olac:speaker "JK", "UG393" ;
//   dc:available "2014-11-06"^^dc:W3CDTF ;
//   dc:created "1969-04-11"^^dc:W3CDTF ;
//   dc:issued "2014-12-05T15:00:19+01:00"^^dc:W3CDTF ;
//   dc:modified "2014-12-05T15:00:19+01:00"^^dc:W3CDTF ;
//   dc:spatial [
//     a edm:Place ;
//     geo:lat "47.90"^^xsd:float ;
//     geo:long "1.90"^^xsd:float ;
//     skos:note "FR"^^dc:ISO3166, "France, Centre, Loiret, Orléans"@fr ;
//     owl:sameAs <http://vocab.getty.edu/tgn/7008337>
//   ] .
//
// <http://cocoon.huma-num.fr/data/eslo/masters/ESLO1_ENT_019.wav>
//   a edm:WebResource ;
//   dc:extent "PT0H47M16S" ;
//   dc11:format "audio/x-wav"^^dc:IMT ;
//   dc:created "1969-04-11"^^dc:W3CDTF ;
//   dc:issued "2014-12-05T15:00:19+01:00"^^dc:W3CDTF .
//
// <http://cocoon.huma-num.fr/data/eslo/ESLO1_ENT_019_22km.wav>
//   a edm:WebResource ;
//   dc:extent "PT0H47M16S" ;
//   dc11:format "audio/x-wav"^^dc:IMT ;
//   edm:isDerivativeOf <http://cocoon.huma-num.fr/data/eslo/masters/ESLO1_ENT_019.wav> ;
//   dc:created "1969-04-11"^^dc:W3CDTF ;
//   dc:issued "2014-12-05T15:00:19+01:00"^^dc:W3CDTF .
//
// <http://cocoon.huma-num.fr/data/eslo/ESLO1_ENT_019.mp3>
//   a edm:WebResource ;
//   dc:extent "PT0H47M16S" ;
//   dc11:format "audio/mpeg"^^dc:IMT ;
//   edm:isDerivativeOf <http://cocoon.huma-num.fr/data/eslo/masters/ESLO1_ENT_019.wav> ;
//   dc:created "1969-04-11"^^dc:W3CDTF ;
//   dc:issued "2014-12-05T15:00:19+01:00"^^dc:W3CDTF .

class CocoonSoundRdfMerger extends CocoonAbstractRdfMerger {

    protected function getTypeMergeMethodMap() {
        return [
            'http://www.openarchives.org/ore/terms/Aggregation' => 'mergeOreAggregation',
            'http://www.europeana.eu/schemas/edm/ProvidedCHO' => 'mergeEdmProvidedCHO',
            'http://www.europeana.eu/schemas/edm/WebResource' => 'mergeEdmWebResources',
            'http://www.europeana.eu/schemas/edm/Place' => 'mergeDcSpatialBlankNode'
        ];
    }

    protected function mergeOreAggregation($baseRes, $srcRes, $uri = null) {

        if(is_null($uri)) {
            $uri = $baseRes->getUri();
        }
        $targetArray =& $this->mergedArray[$uri];

        $this->mergeProperties([], [
            "http://www.europeana.eu/schemas/edm/aggregatedCHO",
            "http://www.europeana.eu/schemas/edm/provider",
            "http://www.europeana.eu/schemas/edm/dataProvider",
            "http://www.europeana.eu/schemas/edm/isShownAt",
            "http://www.europeana.eu/schemas/edm/isShownBy"
        ], $targetArray, $baseRes, $srcRes);

    }

    protected function mergeEdmProvidedCHO($baseRes, $srcRes, $uri=null) {
        if(is_null($uri)) {
            $uri = $baseRes->getUri();
        }
        $targetArray =& $this->mergedArray[$uri];

        $this->mergeProperties([
            "http://purl.org/dc/terms/spatial"
        ], [
            "http://purl.org/dc/elements/1.1/title",
            "http://purl.org/dc/terms/extent",
            "http://purl.org/dc/terms/available",
            "http://purl.org/dc/terms/created",
            "http://purl.org/dc/terms/issued",
        ], $targetArray, $baseRes, $srcRes);

        // Must handle modified
        $isBaseText = false;
        foreach ($baseRes->all("dc11:type","resource") as $resType) {
            $type = $resType->getUri();
            if($type === 'http://purl.org/dc/dcmitype/Text') {
                $isBaseText = true;
                break;
            }
        }
        if($isBaseText) {
            // The base is Text. In this case for http://purl.org/dc/terms/mofified,
            // the sound takes over. So we switch baseRes with srcRes in the arguments
            $this->mergeProperties([], ["http://purl.org/dc/terms/mofified"], $targetArray, $srcRes, $baseRes);
        }

    }

    protected function mergeEdmWebResources($baseRes, $srcRes, $uri=null) {
        if(is_null($uri)) {
            $uri = $baseRes->getUri();
        }
        $targetArray =& $this->mergedArray[$uri];
        $this->mergeProperties([],[
            "http://purl.org/dc/terms/extent",
            "http://purl.org/dc/elements/1.1/format",
            "http://www.europeana.eu/schemas/edm/isDerivativeOf",
            "http://purl.org/dc/terms/created",
            "http://purl.org/dc/terms/issued"
        ], $targetArray, $baseRes, $srcRes);
    }

    protected function mergeDcSpatialBlankNode($baseRes, $srcRes, $uri=null) {
        if(is_null($uri)) {
            $uri = $baseRes->getUri();
        }
        $targetArray =& $this->mergedArray[$uri];

        $this->mergeProperties([],[
            "http://www.w3.org/2003/01/geo/wgs84_pos#lat",
            "http://www.w3.org/2003/01/geo/wgs84_pos#long",
            "http://www.w3.org/2003/01/geo/wgs84_pos#alt",
            "http://www.w3.org/2002/07/owl#sameAs"
        ], $targetArray, $baseRes, $srcRes);
    }

}
