<?php
namespace CorpusParole\Libraries\Mappers;

use Config;

use CorpusParole\Libraries\Utils;
use CorpusParole\Libraries\CocoonUtils;

use EasyRdf\RdfNamespace;
use EasyRdf\Graph;
use EasyRdf\Literal;
use EasyRdf\Resource;

/**
 * <http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-UVE_MOCIKA> a <http://crdo.risc.cnrs.fr/schemas/Resource> ;
 * 	<http://purl.org/dc/elements/1.1/description> "Voilà pourquoi le bernard-l'hermite, aujourd'hui, se cache dans les coquilles vides qu'il trouve, alors que le crabe de cocotier n'a pas honte de se promener tout nu."@fr ;
 * 	<http://purl.org/dc/elements/1.1/format> "text/xml"^^<http://purl.org/dc/terms/IMT> ;
 * 	<http://purl.org/dc/elements/1.1/type> "primary_text"^^<http://www.language-archives.org/OLAC/1.1/linguistic-type> , <http://purl.org/dc/dcmitype/Text> , "narrative"^^<http://www.language-archives.org/OLAC/1.1/discourse-type> ;
 * 	<http://purl.org/dc/elements/1.1/subject> <http://lexvo.org/id/iso639-3/uve> ;
 * 	<http://purl.org/dc/elements/1.1/language> <http://lexvo.org/id/iso639-3/uve> ;
 * 	<http://www.language-archives.org/OLAC/1.1/depositor> <http://viaf.org/viaf/56614135> ;
 * 	<http://purl.org/dc/elements/1.1/publisher> <http://viaf.org/viaf/154919513> ;
 * 	<http://purl.org/dc/elements/1.1/rights> "Copyright (c) Moyse-Faurie, Claire" ;
 * 	<http://purl.org/dc/elements/1.1/title> "The two hermit crabs and the coconut crab"@en ;
 * 	<http://purl.org/dc/terms/isFormatOf> <http://cocoon.huma-num.fr/exist/crdo/moyse-faurie/uve/crdo-UVE_MOCIKA.xml> , <http://cocoon.huma-num.fr/exist/crdo/moyse-faurie/uve/crdo-UVE_MOCIKA.xhtml> ;
 * 	<http://purl.org/dc/terms/accessRights> "Freely available for non-commercial use" ;
 * 	<http://purl.org/dc/terms/license> <http://creativecommons.org/licenses/by-nc-sa/2.5/> ;
 * 	<http://purl.org/dc/terms/isPartOf> <http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-COLLECTION_LANGUESDEFRANCE> , <http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-COLLECTION_LACITO> ;
 * 	<http://purl.org/dc/terms/spatial> "NC"^^<http://purl.org/dc/terms/ISO3166> , "New Caledonia, Ohnyat (Ouvéa)" ;
 * 	<http://purl.org/dc/terms/available> "2011-02-05"^^<http://purl.org/dc/terms/W3CDTF> ;
 * 	<http://purl.org/dc/terms/issued> "2011-02-05T23:22:23+01:00"^^<http://purl.org/dc/terms/W3CDTF> ;
 * 	<http://www.language-archives.org/OLAC/1.1/speaker> "Idakote, Félicien" ;
 * 	<http://purl.org/dc/terms/requires> <http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-UVE_MOCIKA_SOUND> ;
 * 	<http://purl.org/dc/terms/alternative> "Les deux bernard-l'hermite et le crabe de cocotier"@fr ;
 * 	<http://www.language-archives.org/OLAC/1.1/researcher> "Moyse-Faurie, Claire" ;
 * 	<http://purl.org/dc/terms/modified> "2002-02-20"^^<http://purl.org/dc/terms/W3CDTF> ;
 * 	<http://purl.org/dc/terms/conformsTo> <http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-dtd_archive> .
 *
 * <http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-UVE_MOCIKA_SOUND> a <http://crdo.risc.cnrs.fr/schemas/Resource> ;
 * 	<http://purl.org/dc/elements/1.1/format> "audio/x-wav"^^<http://purl.org/dc/terms/IMT> ;
 * 	<http://purl.org/dc/elements/1.1/type> <http://purl.org/dc/dcmitype/Sound> , "primary_text"^^<http://www.language-archives.org/OLAC/1.1/linguistic-type> , "narrative"^^<http://www.language-archives.org/OLAC/1.1/discourse-type> ;
 * 	<http://purl.org/dc/elements/1.1/subject> <http://lexvo.org/id/iso639-3/uve> ;
 * 	<http://purl.org/dc/elements/1.1/language> <http://lexvo.org/id/iso639-3/uve> ;
 * 	<http://www.language-archives.org/OLAC/1.1/depositor> <http://viaf.org/viaf/56614135> ;
 * 	<http://purl.org/dc/elements/1.1/publisher> <http://viaf.org/viaf/154919513> ;
 * 	<http://purl.org/dc/elements/1.1/rights> "Copyright (c) Moyse-Faurie, Claire" ;
 * 	<http://purl.org/dc/elements/1.1/title> "The two hermit crabs and the coconut crab"@en ;
 * 	<http://purl.org/dc/terms/isFormatOf> <http://cocoon.huma-num.fr/data/archi/144187_MOCIKA_22km.wav> , <http://cocoon.huma-num.fr/data/archi/mp3/144187_MOCIKA_44k.mp3> ;
 * 	<http://purl.org/dc/terms/accessRights> "Freely available for non-commercial use" ;
 * 	<http://purl.org/dc/terms/license> <http://creativecommons.org/licenses/by-nc-nd/2.5/> ;
 * 	<http://purl.org/dc/terms/isPartOf> <http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-COLLECTION_LANGUESDEFRANCE> , <http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-COLLECTION_LACITO> ;
 * 	<http://purl.org/dc/terms/extent> "PT2M35S" ;
 * 	<http://purl.org/dc/terms/created> "1997-08-29"^^<http://purl.org/dc/terms/W3CDTF> ;
 * 	<http://purl.org/dc/terms/spatial> "NC"^^<http://purl.org/dc/terms/ISO3166> , "New Caledonia, Ohnyat (Ouvéa)" ;
 * 	<http://crdo.risc.cnrs.fr/schemas/master> <http://cocoon.huma-num.fr/data/archi/masters/144187.wav> ;
 * 	<http://purl.org/dc/terms/available> "2010-10-23"^^<http://purl.org/dc/terms/W3CDTF> ;
 * 	<http://purl.org/dc/terms/issued> "2010-10-23T00:08:27+02:00"^^<http://purl.org/dc/terms/W3CDTF> ;
 * 	<http://www.language-archives.org/OLAC/1.1/speaker> "Idakote, Félicien" ;
 * 	<http://www.w3.org/2003/01/geo/wgs84_pos#long> "166.6526"^^xsd:float ;
 * 	<http://www.w3.org/2003/01/geo/wgs84_pos#lat> "-20.4765"^^xsd:float ;
 * 	<http://purl.org/dc/terms/isRequiredBy> <http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-UVE_MOCIKA> ;
 * 	<http://www.language-archives.org/OLAC/1.1/researcher> "Moyse-Faurie, Claire" .
 *
 *  http://purl.org/dc/elements/1.1/description
 *  http://purl.org/dc/elements/1.1/format
 *  http://purl.org/dc/elements/1.1/language
 *  http://purl.org/dc/elements/1.1/publisher
 *  http://purl.org/dc/elements/1.1/rights
 *  http://purl.org/dc/elements/1.1/subject
 *  http://purl.org/dc/elements/1.1/title
 *  http://purl.org/dc/elements/1.1/type
 *  http://purl.org/dc/terms/accessRights
 *  http://purl.org/dc/terms/available
 *  http://purl.org/dc/terms/conformsTo
 *  http://purl.org/dc/terms/created
 *  http://purl.org/dc/terms/isFormatOf
 *  http://purl.org/dc/terms/isPartOf
 *  http://purl.org/dc/terms/issued
 *  http://purl.org/dc/terms/license
 *  http://purl.org/dc/terms/requires
 *  http://www.language-archives.org/OLAC/1.1/data_inputter
 *  http://www.language-archives.org/OLAC/1.1/depositor
 *  http://www.language-archives.org/OLAC/1.1/editor
 *  http://www.language-archives.org/OLAC/1.1/interviewer
 *  http://www.language-archives.org/OLAC/1.1/researcher
 *  http://www.language-archives.org/OLAC/1.1/speaker
 *  http://www.language-archives.org/OLAC/1.1/transcriber
 *  http://www.language-archives.org/OLAC/1.1/author
 *  http://www.language-archives.org/OLAC/1.1/recorder
 *  http://www.language-archives.org/OLAC/1.1/translator
 *  http://www.language-archives.org/OLAC/1.1/responder
 *  http://www.language-archives.org/OLAC/1.1/sponsor
 *  http://www.language-archives.org/OLAC/1.1/annotator
 *  http://www.language-archives.org/OLAC/1.1/participant
 *  http://www.language-archives.org/OLAC/1.1/compiler
 *  http://www.language-archives.org/OLAC/1.1/developer
 *  http://www.language-archives.org/OLAC/1.1/consultant
 *  http://www.language-archives.org/OLAC/1.1/research_participant
 *  http://purl.org/dc/terms/spatial
 *  http://purl.org/dc/terms/tableOfContents
 *  http://www.w3.org/2003/01/geo/wgs84_pos#lat
 *  http://www.w3.org/2003/01/geo/wgs84_pos#long
 *  http://purl.org/dc/terms/alternative
 *  http://purl.org/dc/terms/modified
 *  http://purl.org/dc/elements/1.1/identifier
 *  http://purl.org/dc/terms/extent
 *  http://purl.org/dc/terms/medium
 *  http://purl.org/dc/elements/1.1/source
 *  http://purl.org/dc/elements/1.1/coverage
 *  http://crdo.risc.cnrs.fr/schemas/master
 *  http://purl.org/dc/elements/1.1/creator
 *  http://purl.org/dc/elements/1.1/reference
 *  http://purl.org/dc/terms/references
 *  http://purl.org/dc/terms/abstract
 *  http://purl.org/dc/elements/1.1/relation
 */
class CocoonTextRdfMapper extends CocoonContentRdfMapper {


    protected function getResourceBaseId($res=null) {

        if(is_null($res)) {
            $res = $this->inputGraph->resource($this->uri);
        }
        $soundRes = $res->get('dc:requires');

        if(! $soundRes instanceof Resource) {
            throw new \Exception("Input graph for text not correct, can not find sound resource", 1);
        }

        return $soundRes->getUri();
    }

    protected function addCHOResourceDateProperties($providedCHOResource, $res, $outputGraph) {
        // We do not add date to the providedCHO for Text resource
    }

    // protected function propertyTypeMap($providedCHOResource, $prop, $value) {
    //     if((!$value instanceof Resource) || $value->getUri() !== "http://purl.org/dc/dcmitype/Text") {
    //         $providedCHOResource->add($prop, $value);
    //     }
    // }

    protected function mapWebResources($res, $outputGraph) {
        $resId = CocoonUtils::getIdFromUri($this->getResourceBaseId($res));
        $resUri = CocoonUtils::getCorpusUriFromId($resId);


        $aggregationNode = $outputGraph->resource($resUri, 'ore:Aggregation');

        // build others
        foreach($res->all($this->inputGraph->resource('http://purl.org/dc/terms/isFormatOf')) as $reprUrl) {
            $webResource = $outputGraph->resource($reprUrl, 'edm:WebResource');
            $mimetype = Utils::getMimetype($reprUrl);

            $webResource->addLiteral('http://purl.org/dc/elements/1.1/format', Literal::create($mimetype, null, $outputGraph->resource('http://purl.org/dc/terms/IMT')));

            $this->addDateToWebResource($res, $webResource);
            $aggregationNode->addResource('edm:hasView', $reprUrl);

        }

    }

}
