<?php

namespace CorpusParole\Http\Controllers\Api;

use Illuminate\Http\Request;
use Log;
use Es;

use CorpusParole\Http\Controllers\Controller;
use CorpusParole\Libraries\Filters\CorpusFilterManager;


class DateStatsController extends Controller
{
    private function getStatQuery($query) {
        return [
            'index' => config('elasticsearch.index'),
            'body' => [
                "size" => 0,
                "query" => $query,
                "aggs" => [
                    "datestats" => [
                        "nested"=> [
                            "path" => "creation_years"
                        ],
                        "aggs" => [
                            "years" => [
                                "terms"=> [
                                    "field" => "creation_years.year",
                                    "size" => 2147483647,
                                    "order" => [
                                        "_term" => "asc"
                                    ]
                                ],
                                "aggs" => [
                                    "year_count" => [
                                        "sum" => [
                                            "field" => "creation_years.weight"
                                        ]
                                    ]
                                ]
                            ]
                        ]
                    ]
                ]
            ]
        ];
    }

    private function getMinMaxQuery($query) {
        return [
            'index' => config('elasticsearch.index'),
            'body' => [
                "size" => 0,
                "query" => $query,
                "aggs" => [
                    "datestats" => [
                        "nested"=> [
                            "path" => "creation_years"
                        ],
                        "aggs" => [
                            "minyear" => [
                                "min" => [ "field"=> "creation_years.year" ]
                            ],
                            "maxyear" => [
                                "max" => [ "field"=> "creation_years.year" ]
                            ]
                        ]
                    ]
                ]
            ]
        ];
    }

    private function getDocQuery(Request $request) {
        $filterManager = new CorpusFilterManager();
        $filters = $filterManager->prepareFilters($request);
        unset($filters['dates']);
        $qFilterParts = $filterManager->buildESFilters($filters);

        return $filterManager->buildQuery($qFilterParts);
    }

    /**
     * Display the min max date stats
     */
    public function minmax(Request $request) {
        $query = $this->getDocQuery($request);

        $esQuery = $this->getMinMaxQuery($query);
        $esRes = Es::search($esQuery);

        $datestats = [];

        $max = intval($esRes['aggregations']['datestats']['maxyear']['value']);
        $min = intval($esRes['aggregations']['datestats']['minyear']['value']);

        return response()->json(['dateminmax' => [ $min, $max ] ]);
    }

    /**
     * Display the dates stats
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {

        $query = $this->getDocQuery($request);

        $esQuery = $this->getStatQuery($query);
        $esRes = Es::search($esQuery);

        $datestats = [];

        foreach($esRes['aggregations']['datestats']['years']['buckets'] as $bucket) {
            $c = round($bucket['year_count']['value']);
            if($c > 0) {
                $datestats[(string)($bucket['key'])] = $c;
            }
        }

        return response()->json(['datestats' => $datestats ]);
    }

}
